/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.master.BlockInfo;
import tachyon.master.MasterInfo;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

public class WebInterfaceBrowseServlet
extends HttpServlet {
    private static final long serialVersionUID = 6121623049981468871L;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private MasterInfo mMasterInfo;

    public WebInterfaceBrowseServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, UnknownHostException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("invalidPathError", (Object)"");
        List<ClientFileInfo> filesInfo = null;
        String currentPath = request.getParameter("path");
        if (currentPath.isEmpty()) {
            currentPath = "/";
        }
        request.setAttribute("currentPath", (Object)currentPath);
        request.setAttribute("viewingOffset", (Object)0);
        try {
            UiFileInfo currentFileInfo = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
            request.setAttribute("currentDirectory", (Object)currentFileInfo);
            request.setAttribute("blockSizeByte", (Object)currentFileInfo.BLOCK_SIZE_BYTES);
            if (!currentFileInfo.getIsDirectory()) {
                String tmpParam = request.getParameter("offset");
                int offset = tmpParam == null ? 0 : Integer.valueOf(tmpParam);
                this.displayFile(currentFileInfo.getAbsolutePath(), request, offset);
                request.setAttribute("viewingOffset", (Object)offset);
                this.getServletContext().getRequestDispatcher("/viewFile.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            CommonUtils.validatePath(currentPath);
            this.setPathDirectories(currentPath, request);
            filesInfo = this.mMasterInfo.getFilesInfo(currentPath);
        }
        catch (FileDoesNotExistException fdne) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (InvalidPathException ipe) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ArrayList<UiFileInfo> fileInfos = new ArrayList<UiFileInfo>(filesInfo.size());
        for (ClientFileInfo fileInfo : filesInfo) {
            UiFileInfo toAdd = new UiFileInfo(fileInfo);
            try {
                if (!toAdd.getIsDirectory() && fileInfo.getLength() > 0L) {
                    toAdd.setFileLocations(this.mMasterInfo.getFileLocations(toAdd.getId()).get(0).getLocations());
                }
            }
            catch (FileDoesNotExistException fdne) {
                request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
                this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            fileInfos.add(toAdd);
        }
        Collections.sort(fileInfos);
        request.setAttribute("fileInfos", fileInfos);
        this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void displayFile(String path, HttpServletRequest request) throws FileDoesNotExistException, InvalidPathException, IOException {
        this.displayFile(path, request, 0);
    }

    private void displayFile(String path, HttpServletRequest request, int offset) throws FileDoesNotExistException, InvalidPathException, IOException {
        String masterAddress = "tachyon://" + this.mMasterInfo.getMasterAddress().getHostName() + ":" + this.mMasterInfo.getMasterAddress().getPort();
        TachyonFS tachyonClient = TachyonFS.get(masterAddress);
        TachyonFile tFile = tachyonClient.getFile(path);
        String fileData = null;
        if (tFile == null) {
            throw new FileDoesNotExistException(path);
        }
        if (tFile.isComplete()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            int len = (int)Math.min(5120L, tFile.length());
            byte[] data = new byte[len];
            is.skip(offset);
            is.read(data, 0, len);
            fileData = CommonUtils.convertByteArrayToStringWithoutEscape(data);
            if (fileData == null) {
                fileData = "The requested file is not completely encoded in ascii";
            }
            is.close();
        } else {
            fileData = "The requested file is not complete yet.";
        }
        try {
            tachyonClient.close();
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
        }
        List<BlockInfo> rawBlockList = this.mMasterInfo.getBlockList(path);
        ArrayList<UiBlockInfo> uiBlockInfo = new ArrayList<UiBlockInfo>();
        for (BlockInfo blockInfo : rawBlockList) {
            uiBlockInfo.add(new UiBlockInfo(blockInfo));
        }
        request.setAttribute("fileBlocks", uiBlockInfo);
        request.setAttribute("fileData", (Object)fileData);
    }

    private void setPathDirectories(String path, HttpServletRequest request) throws FileDoesNotExistException, InvalidPathException {
        if (path.equals("/")) {
            request.setAttribute("pathInfos", (Object)new UiFileInfo[0]);
            return;
        }
        String[] splitPath = path.split("/");
        UiFileInfo[] pathInfos = new UiFileInfo[splitPath.length - 1];
        String currentPath = "/";
        pathInfos[0] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
        for (int i = 1; i < splitPath.length - 1; ++i) {
            currentPath = currentPath + splitPath[i];
            pathInfos[i] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
            currentPath = currentPath + "/";
        }
        request.setAttribute("pathInfos", (Object)pathInfos);
    }

    public class UiBlockInfo
    implements Comparable<UiBlockInfo> {
        private final long ID;
        private final long BLOCK_LENGTH;
        private final boolean IN_MEMORY;

        public UiBlockInfo(BlockInfo blockInfo) {
            this.ID = blockInfo.BLOCK_ID;
            this.BLOCK_LENGTH = blockInfo.LENGTH;
            this.IN_MEMORY = blockInfo.isInMemory();
        }

        public long getID() {
            return this.ID;
        }

        public long getBlockLength() {
            return this.BLOCK_LENGTH;
        }

        public boolean inMemory() {
            return this.IN_MEMORY;
        }

        @Override
        public int compareTo(UiBlockInfo p) {
            return this.ID < p.ID ? -1 : (this.ID == p.ID ? 0 : 1);
        }
    }

    public class UiFileInfo
    implements Comparable<UiFileInfo> {
        private final int ID;
        private final int DEPENDENCY_ID;
        private final String NAME;
        private final String ABSOLUATE_PATH;
        private final String CHECKPOINT_PATH;
        private final long BLOCK_SIZE_BYTES;
        private final long SIZE;
        private final long CREATION_TIME_MS;
        private final boolean IN_MEMORY;
        private final int IN_MEMORY_PERCENTAGE;
        private final boolean IS_DIRECTORY;
        private List<String> mFileLocations;

        private UiFileInfo(ClientFileInfo fileInfo) {
            this.ID = fileInfo.getId();
            this.DEPENDENCY_ID = fileInfo.getDependencyId();
            this.NAME = fileInfo.getName();
            this.ABSOLUATE_PATH = fileInfo.getPath();
            this.CHECKPOINT_PATH = fileInfo.getCheckpointPath();
            this.BLOCK_SIZE_BYTES = fileInfo.getBlockSizeByte();
            this.SIZE = fileInfo.getLength();
            this.CREATION_TIME_MS = fileInfo.getCreationTimeMs();
            this.IN_MEMORY = fileInfo.isInMemory();
            this.IN_MEMORY_PERCENTAGE = fileInfo.getInMemoryPercentage();
            this.IS_DIRECTORY = fileInfo.isFolder();
            this.mFileLocations = new ArrayList<String>();
        }

        public int getId() {
            return this.ID;
        }

        public int getDependencyId() {
            return this.DEPENDENCY_ID;
        }

        public String getName() {
            if (this.ABSOLUATE_PATH.equals("/")) {
                return "root";
            }
            return this.NAME;
        }

        public String getAbsolutePath() {
            return this.ABSOLUATE_PATH;
        }

        public String getBlockSizeBytes() {
            if (this.IS_DIRECTORY) {
                return " ";
            }
            return CommonUtils.getSizeFromBytes(this.BLOCK_SIZE_BYTES);
        }

        public String getCheckpointPath() {
            return this.CHECKPOINT_PATH;
        }

        public String getSize() {
            if (this.IS_DIRECTORY) {
                return " ";
            }
            return CommonUtils.getSizeFromBytes(this.SIZE);
        }

        public String getCreationTime() {
            return CommonUtils.convertMsToDate(this.CREATION_TIME_MS);
        }

        public boolean getInMemory() {
            return this.IN_MEMORY;
        }

        public int getInMemoryPercentage() {
            return this.IN_MEMORY_PERCENTAGE;
        }

        public boolean getIsDirectory() {
            return this.IS_DIRECTORY;
        }

        public void setFileLocations(List<NetAddress> fileLocations) {
            for (NetAddress addr : fileLocations) {
                this.mFileLocations.add(new String(addr.getMHost() + ":" + addr.getMPort()));
            }
        }

        public List<String> getFileLocations() {
            return this.mFileLocations;
        }

        @Override
        public int compareTo(UiFileInfo o) {
            return this.ABSOLUATE_PATH.compareTo(o.getAbsolutePath());
        }
    }
}

