/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.Users;
import tachyon.conf.CommonConf;
import tachyon.conf.WorkerConf;
import tachyon.master.BlockInfo;
import tachyon.master.MasterClient;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.Command;
import tachyon.thrift.FailedToCheckpointException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.util.CommonUtils;
import tachyon.worker.WorkerSpaceCounter;

public class WorkerStorage {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final CommonConf COMMON_CONF;
    private volatile MasterClient mMasterClient;
    private InetSocketAddress mMasterAddress;
    private InetSocketAddress mWorkerAddress;
    private WorkerSpaceCounter mWorkerSpaceCounter;
    private long mWorkerId;
    private Set<Long> mMemoryData = new HashSet<Long>();
    private Map<Long, Long> mBlockSizes = new HashMap<Long, Long>();
    private Map<Long, Long> mLatestBlockAccessTimeMs = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> mUsersPerLockedBlock = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> mLockedBlocksPerUser = new HashMap<Long, Set<Long>>();
    private BlockingQueue<Long> mRemovedBlockList = new ArrayBlockingQueue<Long>(10000);
    private BlockingQueue<Long> mAddedBlockList = new ArrayBlockingQueue<Long>(10000);
    private File mLocalDataFolder;
    private File mLocalUserFolder;
    private String mUnderfsWorkerFolder;
    private String mUnderfsWorkerDataFolder;
    private String mUnderfsOrphansFolder;
    private UnderFileSystem mUnderFs;
    private Users mUsers;
    private Object mDependencyLock = new Object();
    private Set<Integer> mUncheckpointFiles = new HashSet<Integer>();
    private Map<Integer, Set<Integer>> mDepIdToFiles = new HashMap<Integer, Set<Integer>>();
    private List<Integer> mPriorityDependencies = new ArrayList<Integer>();
    private ArrayList<Thread> mCheckpointThreads;

    public WorkerStorage(InetSocketAddress masterAddress, InetSocketAddress workerAddress, String dataFolder, long memoryCapacityBytes) {
        this.mCheckpointThreads = new ArrayList(WorkerConf.get().WORKER_CHECKPOINT_THREADS);
        this.COMMON_CONF = CommonConf.get();
        this.mMasterAddress = masterAddress;
        this.mMasterClient = new MasterClient(this.mMasterAddress);
        this.mWorkerAddress = workerAddress;
        this.mWorkerSpaceCounter = new WorkerSpaceCounter(memoryCapacityBytes);
        this.mWorkerId = 0L;
        while (this.mWorkerId == 0L) {
            try {
                this.mMasterClient.connect();
                this.mWorkerId = this.mMasterClient.worker_register(new NetAddress(this.mWorkerAddress.getHostName(), this.mWorkerAddress.getPort()), this.mWorkerSpaceCounter.getCapacityBytes(), 0L, new ArrayList<Long>());
            }
            catch (BlockInfoException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                this.mWorkerId = 0L;
                CommonUtils.sleepMs(this.LOG, 1000L);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                this.mWorkerId = 0L;
                CommonUtils.sleepMs(this.LOG, 1000L);
            }
        }
        this.mLocalDataFolder = new File(dataFolder);
        this.mLocalUserFolder = new File(this.mLocalDataFolder.toString(), WorkerConf.get().USER_TEMP_RELATIVE_FOLDER);
        this.mUnderfsWorkerFolder = this.COMMON_CONF.UNDERFS_WORKERS_FOLDER + "/" + this.mWorkerId;
        this.mUnderfsWorkerDataFolder = this.mUnderfsWorkerFolder + "/data";
        this.mUnderFs = UnderFileSystem.get(this.COMMON_CONF.UNDERFS_ADDRESS);
        this.mUsers = new Users(this.mLocalUserFolder.toString(), this.mUnderfsWorkerFolder);
        for (int k = 0; k < WorkerConf.get().WORKER_CHECKPOINT_THREADS; ++k) {
            Thread thread = new Thread(new CheckpointThread(k));
            this.mCheckpointThreads.add(thread);
            thread.start();
        }
        try {
            this.initializeWorkerStorage();
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        catch (FileDoesNotExistException e) {
            CommonUtils.runtimeException(e);
        }
        catch (SuspectedFileSizeException e) {
            CommonUtils.runtimeException(e);
        }
        catch (BlockInfoException e) {
            CommonUtils.runtimeException(e);
        }
        catch (TException e) {
            CommonUtils.runtimeException(e);
        }
        this.LOG.info((Object)("Current Worker Info: ID " + this.mWorkerId + ", ADDRESS: " + this.mWorkerAddress + ", MemoryCapacityBytes: " + this.mWorkerSpaceCounter.getCapacityBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessBlock(long blockId) {
        Map<Long, Long> map = this.mLatestBlockAccessTimeMs;
        synchronized (map) {
            this.mLatestBlockAccessTimeMs.put(blockId, System.currentTimeMillis());
        }
    }

    public void addCheckpoint(long userId, int fileId) throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, TException {
        long fileSize;
        String srcPath = this.getUserUnderfsTempFolder(userId) + "/" + fileId;
        String dstPath = this.COMMON_CONF.UNDERFS_DATA_FOLDER + "/" + fileId;
        try {
            if (!this.mUnderFs.rename(srcPath, dstPath)) {
                throw new FailedToCheckpointException("Failed to rename " + srcPath + " to " + dstPath);
            }
        }
        catch (IOException e) {
            throw new FailedToCheckpointException("Failed to rename " + srcPath + " to " + dstPath);
        }
        try {
            fileSize = this.mUnderFs.getFileSize(dstPath);
        }
        catch (IOException e) {
            throw new FailedToCheckpointException("Failed to getFileSize " + dstPath);
        }
        this.mMasterClient.addCheckpoint(this.mWorkerId, fileId, fileSize, dstPath);
    }

    private void addFoundBlock(long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        this.addBlockId(blockId, length);
        this.mMasterClient.worker_cacheBlock(this.mWorkerId, this.mWorkerSpaceCounter.getUsedBytes(), blockId, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockId(long blockId, long fileSizeBytes) {
        Map<Long, Long> map = this.mLatestBlockAccessTimeMs;
        synchronized (map) {
            this.mLatestBlockAccessTimeMs.put(blockId, System.currentTimeMillis());
            this.mBlockSizes.put(blockId, fileSizeBytes);
            this.mMemoryData.add(blockId);
        }
    }

    public void cacheBlock(long userId, long blockId) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        File srcFile = new File(this.getUserTempFolder(userId) + "/" + blockId);
        File dstFile = new File(this.mLocalDataFolder + "/" + blockId);
        long fileSizeBytes = srcFile.length();
        if (!srcFile.exists()) {
            throw new FileDoesNotExistException("File " + srcFile + " does not exist.");
        }
        if (!srcFile.renameTo(dstFile)) {
            throw new FileDoesNotExistException("Failed to rename file from " + srcFile.getPath() + " to " + dstFile.getPath());
        }
        this.addBlockId(blockId, fileSizeBytes);
        this.mUsers.addOwnBytes(userId, -fileSizeBytes);
        this.mMasterClient.worker_cacheBlock(this.mWorkerId, this.mWorkerSpaceCounter.getUsedBytes(), blockId, fileSizeBytes);
        this.LOG.info((Object)(userId + " " + dstFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStatus() {
        List<Long> removedUsers = this.mUsers.checkStatus();
        for (long userId : removedUsers) {
            this.mWorkerSpaceCounter.returnUsedBytes(this.mUsers.removeUser(userId));
            Map<Long, Set<Long>> map = this.mUsersPerLockedBlock;
            synchronized (map) {
                Set<Long> blockds = this.mLockedBlocksPerUser.get(userId);
                this.mLockedBlocksPerUser.remove(userId);
                if (blockds != null) {
                    for (long blockId : blockds) {
                        try {
                            this.unlockBlock(blockId, userId);
                        }
                        catch (TException e) {
                            CommonUtils.runtimeException(e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long freeBlock(long blockId) {
        Long freedFileBytes = null;
        if (this.mBlockSizes.containsKey(blockId)) {
            this.mWorkerSpaceCounter.returnUsedBytes(this.mBlockSizes.get(blockId));
            File srcFile = new File(this.mLocalDataFolder + "/" + blockId);
            srcFile.delete();
            Map<Long, Long> map = this.mLatestBlockAccessTimeMs;
            synchronized (map) {
                this.mLatestBlockAccessTimeMs.remove(blockId);
                freedFileBytes = this.mBlockSizes.remove(blockId);
                this.mRemovedBlockList.add(blockId);
                this.mMemoryData.remove(blockId);
            }
            this.LOG.info((Object)("Removed Data " + blockId));
        } else {
            this.LOG.warn((Object)("File " + blockId + " does not exist in memory."));
        }
        return freedFileBytes == null ? 0L : freedFileBytes;
    }

    public void freeBlocks(List<Long> blocks) {
        for (long blockId : blocks) {
            this.freeBlock(blockId);
        }
    }

    private void swapoutOrphanBlocks(long blockId, File file) throws IOException {
        RandomAccessFile localFile = new RandomAccessFile(file, "r");
        MappedByteBuffer buf = localFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        String ufsOrphanBlock = this.mUnderfsOrphansFolder + "/" + blockId;
        OutputStream os = this.mUnderFs.create(ufsOrphanBlock);
        int BULKSIZE = 65536;
        byte[] bulk = new byte[BULKSIZE];
        for (int k = 0; k < (buf.limit() + BULKSIZE - 1) / BULKSIZE; ++k) {
            int len = BULKSIZE < buf.remaining() ? BULKSIZE : buf.remaining();
            buf.get(bulk, 0, len);
            os.write(bulk, 0, len);
        }
        os.close();
        localFile.close();
    }

    public String getDataFolder() throws TException {
        return this.mLocalDataFolder.toString();
    }

    public String getUserTempFolder(long userId) throws TException {
        String ret = this.mUsers.getUserTempFolder(userId);
        this.LOG.info((Object)("Return UserTempFolder for " + userId + " : " + ret));
        return ret;
    }

    public String getUserUnderfsTempFolder(long userId) throws TException {
        String ret = this.mUsers.getUserUnderfsTempFolder(userId);
        this.LOG.info((Object)("Return UserHdfsTempFolder for " + userId + " : " + ret));
        return ret;
    }

    public Command heartbeat() throws BlockInfoException, TException {
        ArrayList<Long> sendRemovedPartitionList = new ArrayList<Long>();
        while (this.mRemovedBlockList.size() > 0) {
            sendRemovedPartitionList.add((Long)this.mRemovedBlockList.poll());
        }
        return this.mMasterClient.worker_heartbeat(this.mWorkerId, this.mWorkerSpaceCounter.getUsedBytes(), sendRemovedPartitionList);
    }

    private void initializeWorkerStorage() throws IOException, FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        this.LOG.info((Object)"Initializing the worker storage.");
        if (!this.mLocalDataFolder.exists()) {
            this.LOG.info((Object)("Local folder " + this.mLocalDataFolder + " does not exist. Creating a new one."));
            this.mLocalDataFolder.mkdir();
            this.mLocalUserFolder.mkdir();
            return;
        }
        if (!this.mLocalDataFolder.isDirectory()) {
            String tmp = "Data folder " + this.mLocalDataFolder + " is not a folder!";
            this.LOG.error((Object)tmp);
            throw new IllegalArgumentException(tmp);
        }
        if (this.mLocalUserFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.mLocalUserFolder);
            }
            catch (IOException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.mLocalUserFolder.mkdir();
        this.mUnderfsOrphansFolder = this.mUnderfsWorkerFolder + "/orphans";
        if (!this.mUnderFs.exists(this.mUnderfsOrphansFolder)) {
            this.mUnderFs.mkdirs(this.mUnderfsOrphansFolder, true);
        }
        int cnt = 0;
        for (File tFile : this.mLocalDataFolder.listFiles()) {
            if (!tFile.isFile()) continue;
            this.LOG.info((Object)("File " + ++cnt + ": " + tFile.getPath() + " with size " + tFile.length() + " Bs."));
            long blockId = CommonUtils.getBlockIdFromFileName(tFile.getName());
            boolean success = this.mWorkerSpaceCounter.requestSpaceBytes(tFile.length());
            try {
                this.addFoundBlock(blockId, tFile.length());
            }
            catch (FileDoesNotExistException e) {
                this.LOG.error((Object)("BlockId: " + blockId + " becomes orphan for: \"" + e.message + "\""));
                this.LOG.info((Object)("Swapout File " + cnt + ": blockId: " + blockId + " to " + this.mUnderfsOrphansFolder));
                this.swapoutOrphanBlocks(blockId, tFile);
                this.freeBlock(blockId);
                continue;
            }
            this.mAddedBlockList.add(blockId);
            if (success) continue;
            CommonUtils.runtimeException("Pre-existing files exceed the local memory capacity.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockBlock(long blockId, long userId) throws TException {
        Map<Long, Set<Long>> map = this.mUsersPerLockedBlock;
        synchronized (map) {
            if (!this.mUsersPerLockedBlock.containsKey(blockId)) {
                this.mUsersPerLockedBlock.put(blockId, new HashSet());
            }
            this.mUsersPerLockedBlock.get(blockId).add(userId);
            if (!this.mLockedBlocksPerUser.containsKey(userId)) {
                this.mLockedBlocksPerUser.put(userId, new HashSet());
            }
            this.mLockedBlocksPerUser.get(userId).add(blockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean memoryEvictionLRU(long requestBytes) {
        Set<Object> pinList = new HashSet();
        try {
            pinList = this.mMasterClient.worker_getPinIdList();
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            pinList = new HashSet();
        }
        Map<Long, Long> map = this.mLatestBlockAccessTimeMs;
        synchronized (map) {
            Map<Long, Set<Long>> map2 = this.mUsersPerLockedBlock;
            synchronized (map2) {
                while (this.mWorkerSpaceCounter.getAvailableBytes() < requestBytes) {
                    long blockId = -1L;
                    long latestTimeMs = Long.MAX_VALUE;
                    for (Map.Entry<Long, Long> entry : this.mLatestBlockAccessTimeMs.entrySet()) {
                        if (entry.getValue() >= latestTimeMs || pinList.contains(BlockInfo.computeInodeId(entry.getKey())) || this.mUsersPerLockedBlock.containsKey(entry.getKey())) continue;
                        blockId = entry.getKey();
                        latestTimeMs = entry.getValue();
                    }
                    if (blockId != -1L) {
                        this.freeBlock(blockId);
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void register() {
        long id = 0L;
        while (id == 0L) {
            try {
                this.mMasterClient.connect();
                id = this.mMasterClient.worker_register(new NetAddress(this.mWorkerAddress.getHostName(), this.mWorkerAddress.getPort()), this.mWorkerSpaceCounter.getCapacityBytes(), 0L, new ArrayList<Long>(this.mMemoryData));
            }
            catch (BlockInfoException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                id = 0L;
                CommonUtils.sleepMs(this.LOG, 1000L);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                id = 0L;
                CommonUtils.sleepMs(this.LOG, 1000L);
            }
        }
        this.mWorkerId = id;
    }

    public void returnSpace(long userId, long returnedBytes) throws TException {
        long preAvailableBytes = this.mWorkerSpaceCounter.getAvailableBytes();
        if (returnedBytes > this.mUsers.ownBytes(userId)) {
            this.LOG.error((Object)("User " + userId + " does not own " + returnedBytes + " bytes."));
        } else {
            this.mWorkerSpaceCounter.returnUsedBytes(returnedBytes);
            this.mUsers.addOwnBytes(userId, -returnedBytes);
        }
        this.LOG.info((Object)("returnSpace(" + userId + ", " + returnedBytes + ") : " + preAvailableBytes + " returned: " + returnedBytes + ". New Available: " + this.mWorkerSpaceCounter.getAvailableBytes()));
    }

    public boolean requestSpace(long userId, long requestBytes) throws TException {
        this.LOG.info((Object)("requestSpace(" + userId + ", " + requestBytes + "): Current available: " + this.mWorkerSpaceCounter.getAvailableBytes() + " requested: " + requestBytes));
        if (this.mWorkerSpaceCounter.getCapacityBytes() < requestBytes) {
            this.LOG.info((Object)"user_requestSpace(): requested memory size is larger than the total memory on the machine.");
            return false;
        }
        while (!this.mWorkerSpaceCounter.requestSpaceBytes(requestBytes)) {
            if (this.memoryEvictionLRU(requestBytes)) continue;
            return false;
        }
        this.mUsers.addOwnBytes(userId, requestBytes);
        return true;
    }

    public void resetMasterClient() {
        MasterClient tMasterClient = new MasterClient(this.mMasterAddress);
        tMasterClient.connect();
        this.mMasterClient = tMasterClient;
    }

    public void stop() {
        this.mMasterClient.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockBlock(long blockId, long userId) throws TException {
        Map<Long, Set<Long>> map = this.mUsersPerLockedBlock;
        synchronized (map) {
            if (this.mUsersPerLockedBlock.containsKey(blockId)) {
                this.mUsersPerLockedBlock.get(blockId).remove(userId);
                if (this.mUsersPerLockedBlock.get(blockId).size() == 0) {
                    this.mUsersPerLockedBlock.remove(blockId);
                }
            }
            if (this.mLockedBlocksPerUser.containsKey(userId)) {
                this.mLockedBlocksPerUser.get(userId).remove(blockId);
            }
        }
    }

    public void userHeartbeat(long userId) throws TException {
        this.mUsers.userHeartbeat(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean asyncCheckpoint(int fileId) throws IOException, TException {
        ClientFileInfo fileInfo = this.mMasterClient.getClientFileInfoById(fileId);
        if (fileInfo.getDependencyId() != -1) {
            Object object = this.mDependencyLock;
            synchronized (object) {
                this.mUncheckpointFiles.add(fileId);
                if (!this.mDepIdToFiles.containsKey(fileInfo.getDependencyId())) {
                    this.mDepIdToFiles.put(fileInfo.getDependencyId(), new HashSet());
                }
                this.mDepIdToFiles.get(fileInfo.getDependencyId()).add(fileId);
            }
            return true;
        }
        return false;
    }

    public String getUnderfsOrphansFolder() {
        return this.mUnderfsOrphansFolder;
    }

    public class CheckpointThread
    implements Runnable {
        private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
        private final int ID;
        private UnderFileSystem mCheckpointUnderFs = null;

        public CheckpointThread(int id) {
            this.ID = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int k;
                        int fileId = -1;
                        Object object = WorkerStorage.this.mDependencyLock;
                        synchronized (object) {
                            fileId = this.getFileIdBasedOnPriorityDependency();
                            if (fileId == -1) {
                                if (WorkerStorage.this.mPriorityDependencies.size() == 0) {
                                    WorkerStorage.this.mPriorityDependencies = this.getSortedPriorityDependencyList();
                                    if (!WorkerStorage.this.mPriorityDependencies.isEmpty()) {
                                        this.LOG.info((Object)("Get new mPriorityDependencies " + CommonUtils.listToString(WorkerStorage.this.mPriorityDependencies)));
                                    }
                                } else {
                                    List<Integer> tList = this.getSortedPriorityDependencyList();
                                    boolean equal = true;
                                    if (WorkerStorage.this.mPriorityDependencies.size() != tList.size()) {
                                        equal = false;
                                    }
                                    if (equal) {
                                        for (int k2 = 0; k2 < tList.size(); ++k2) {
                                            if (tList.get(k2) == WorkerStorage.this.mPriorityDependencies.get(k2)) continue;
                                            equal = false;
                                            break;
                                        }
                                    }
                                    if (!equal) {
                                        WorkerStorage.this.mPriorityDependencies = tList;
                                    }
                                }
                                fileId = this.getFileIdBasedOnPriorityDependency();
                            }
                            if (fileId == -1) {
                                fileId = this.getRandomUncheckpointedFile();
                            }
                        }
                        if (fileId == -1) {
                            this.LOG.debug((Object)("Thread " + this.ID + " has nothing to checkpoint. Sleep for 1 sec."));
                            CommonUtils.sleepMs(this.LOG, 1000L);
                            continue;
                        }
                        String midPath = WorkerStorage.this.mUnderfsWorkerDataFolder + "/" + fileId;
                        String dstPath = CommonConf.get().UNDERFS_DATA_FOLDER + "/" + fileId;
                        this.LOG.info((Object)("Thread " + this.ID + " is checkpointing file " + fileId + " from " + WorkerStorage.this.mLocalDataFolder.toString() + " to " + midPath + " to " + dstPath));
                        if (this.mCheckpointUnderFs == null) {
                            this.mCheckpointUnderFs = UnderFileSystem.get(midPath);
                        }
                        long startCopyTimeMs = System.currentTimeMillis();
                        ClientFileInfo fileInfo = WorkerStorage.this.mMasterClient.getClientFileInfoById(fileId);
                        if (!fileInfo.isComplete()) {
                            this.LOG.error((Object)("File " + fileInfo + " is not complete!"));
                            continue;
                        }
                        for (int k3 = 0; k3 < fileInfo.blockIds.size(); ++k3) {
                            WorkerStorage.this.lockBlock(fileInfo.blockIds.get(k3), -2L);
                        }
                        OutputStream os = this.mCheckpointUnderFs.create(midPath, (int)fileInfo.getBlockSizeByte());
                        long fileSizeByte = 0L;
                        for (k = 0; k < fileInfo.blockIds.size(); ++k) {
                            File tempFile = new File(WorkerStorage.this.mLocalDataFolder.toString() + "/" + fileInfo.blockIds.get(k));
                            fileSizeByte += tempFile.length();
                            FileInputStream is = new FileInputStream(tempFile);
                            byte[] buf = new byte[16384];
                            int got = ((InputStream)is).read(buf);
                            while (got != -1) {
                                os.write(buf, 0, got);
                                got = ((InputStream)is).read(buf);
                            }
                            ((InputStream)is).close();
                        }
                        os.close();
                        if (!this.mCheckpointUnderFs.rename(midPath, dstPath)) {
                            this.LOG.error((Object)("Failed to rename from " + midPath + " to " + dstPath));
                        }
                        WorkerStorage.this.mMasterClient.addCheckpoint(WorkerStorage.this.mWorkerId, fileId, fileSizeByte, dstPath);
                        for (k = 0; k < fileInfo.blockIds.size(); ++k) {
                            WorkerStorage.this.unlockBlock(fileInfo.blockIds.get(k), -2L);
                        }
                        long shouldTakeMs = (long)(1000.0 * (double)fileSizeByte / 1048576.0 / (double)WorkerConf.get().WORKER_PER_THREAD_CHECKPOINT_CAP_MB_SEC);
                        long currentTimeMs = System.currentTimeMillis();
                        if (startCopyTimeMs + shouldTakeMs <= currentTimeMs) continue;
                        long shouldSleepMs = startCopyTimeMs + shouldTakeMs - currentTimeMs;
                        this.LOG.info((Object)("Checkpointed last file " + fileId + " took " + (currentTimeMs - startCopyTimeMs) + " ms. Need to sleep " + shouldSleepMs + " ms."));
                        CommonUtils.sleepMs(this.LOG, shouldSleepMs);
                    }
                }
                catch (FileDoesNotExistException e) {
                    this.LOG.warn((Object)e);
                    continue;
                }
                catch (SuspectedFileSizeException e) {
                    this.LOG.error((Object)e);
                    continue;
                }
                catch (BlockInfoException e) {
                    this.LOG.error((Object)e);
                    continue;
                }
                catch (IOException e) {
                    this.LOG.error((Object)e);
                    continue;
                }
                catch (TException e) {
                    this.LOG.warn((Object)e);
                    continue;
                }
                break;
            }
        }

        private List<Integer> getSortedPriorityDependencyList() throws TException {
            List<Integer> ret = WorkerStorage.this.mMasterClient.worker_getPriorityDependencyList();
            for (int i = 0; i < ret.size(); ++i) {
                for (int j = i + 1; j < ret.size(); ++j) {
                    if (ret.get(i) >= ret.get(j)) continue;
                    int k = ret.get(i);
                    ret.set(i, ret.get(j));
                    ret.set(j, k);
                }
            }
            return ret;
        }

        private int getRandomUncheckpointedFile() throws TException {
            if (WorkerStorage.this.mUncheckpointFiles.isEmpty()) {
                return -1;
            }
            Iterator i$ = WorkerStorage.this.mDepIdToFiles.keySet().iterator();
            while (i$.hasNext()) {
                int depId = (Integer)i$.next();
                int fileId = this.getFileIdFromOneDependency(depId);
                if (fileId == -1) continue;
                return fileId;
            }
            return -1;
        }

        private int getFileIdBasedOnPriorityDependency() throws TException {
            if (WorkerStorage.this.mPriorityDependencies.isEmpty()) {
                return -1;
            }
            Iterator i$ = WorkerStorage.this.mPriorityDependencies.iterator();
            while (i$.hasNext()) {
                int depId = (Integer)i$.next();
                int fileId = this.getFileIdFromOneDependency(depId);
                if (fileId == -1) continue;
                return fileId;
            }
            return -1;
        }

        private int getFileIdFromOneDependency(int depId) throws TException {
            Set fileIds = (Set)WorkerStorage.this.mDepIdToFiles.get(depId);
            if (fileIds != null && !fileIds.isEmpty()) {
                int fileId = (Integer)fileIds.iterator().next();
                fileIds.remove(fileId);
                WorkerStorage.this.mUncheckpointFiles.remove(fileId);
                if (fileIds.isEmpty()) {
                    WorkerStorage.this.mDepIdToFiles.remove(depId);
                }
                return fileId;
            }
            return -1;
        }
    }
}

