/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.xolstice.maven.plugin.protobuf.ProtocPlugin;

final class Protoc {
    private static final String LOG_PREFIX = "[PROTOC] ";
    private final String executable;
    private final ImmutableSet<File> protoPathElements;
    private final ImmutableSet<File> protoFiles;
    private final File javaOutputDirectory;
    private final File javaNanoOutputDirectory;
    private final ImmutableSet<ProtocPlugin> plugins;
    private final File pluginDirectory;
    private final String nativePluginId;
    private final String nativePluginExecutable;
    private final String nativePluginParameter;
    private final File cppOutputDirectory;
    private final File pythonOutputDirectory;
    private final File customOutputDirectory;
    private final File descriptorSetFile;
    private final boolean includeImportsInDescriptorSet;
    private final boolean includeSourceInfoInDescriptorSet;
    private final CommandLineUtils.StringStreamConsumer output;
    private final CommandLineUtils.StringStreamConsumer error;

    private Protoc(String executable, ImmutableSet<File> protoPath, ImmutableSet<File> protoFiles, File javaOutputDirectory, File javaNanoOutputDirectory, File cppOutputDirectory, File pythonOutputDirectory, File customOutputDirectory, File descriptorSetFile, boolean includeImportsInDescriptorSet, boolean includeSourceInfoInDescriptorSet, ImmutableSet<ProtocPlugin> plugins, File pluginDirectory, String nativePluginId, String nativePluginExecutable, String nativePluginParameter) {
        this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.protoPathElements = (ImmutableSet)Preconditions.checkNotNull(protoPath, (Object)"protoPath");
        this.protoFiles = (ImmutableSet)Preconditions.checkNotNull(protoFiles, (Object)"protoFiles");
        this.javaOutputDirectory = javaOutputDirectory;
        this.javaNanoOutputDirectory = javaNanoOutputDirectory;
        this.cppOutputDirectory = cppOutputDirectory;
        this.pythonOutputDirectory = pythonOutputDirectory;
        this.customOutputDirectory = customOutputDirectory;
        this.descriptorSetFile = descriptorSetFile;
        this.includeImportsInDescriptorSet = includeImportsInDescriptorSet;
        this.includeSourceInfoInDescriptorSet = includeSourceInfoInDescriptorSet;
        this.plugins = plugins;
        this.pluginDirectory = pluginDirectory;
        this.nativePluginId = nativePluginId;
        this.nativePluginExecutable = nativePluginExecutable;
        this.nativePluginParameter = nativePluginParameter;
        this.error = new CommandLineUtils.StringStreamConsumer();
        this.output = new CommandLineUtils.StringStreamConsumer();
    }

    public int execute(Log log) throws CommandLineException, InterruptedException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.addArguments((String[])this.buildProtocCommand().toArray((Object[])new String[0]));
        int attemptsLeft = 3;
        while (true) {
            try {
                return CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
            }
            catch (CommandLineException e) {
                if (--attemptsLeft == 0 || e.getCause() == null) {
                    throw e;
                }
                log.warn((CharSequence)("[PROTOC] Unable to invoke protoc, will retry " + attemptsLeft + " time(s)"), (Throwable)e);
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    public ImmutableList<String> buildProtocCommand() {
        String outputOption;
        LinkedList command = Lists.newLinkedList();
        for (File protoPathElement : this.protoPathElements) {
            command.add("--proto_path=" + protoPathElement);
        }
        if (this.javaOutputDirectory != null) {
            command.add("--java_out=" + this.javaOutputDirectory);
            for (ProtocPlugin plugin : this.plugins) {
                File pluginExecutable = plugin.getPluginExecutableFile(this.pluginDirectory);
                command.add("--plugin=protoc-gen-" + plugin.getId() + '=' + pluginExecutable);
                command.add("--" + plugin.getId() + "_out=" + this.javaOutputDirectory);
            }
        }
        if (this.javaNanoOutputDirectory != null) {
            outputOption = "--javanano_out=";
            if (this.nativePluginParameter != null) {
                outputOption = outputOption + this.nativePluginParameter + ':';
            }
            outputOption = outputOption + this.javaNanoOutputDirectory;
            command.add(outputOption);
        }
        if (this.cppOutputDirectory != null) {
            command.add("--cpp_out=" + this.cppOutputDirectory);
        }
        if (this.pythonOutputDirectory != null) {
            command.add("--python_out=" + this.pythonOutputDirectory);
        }
        if (this.customOutputDirectory != null) {
            if (this.nativePluginExecutable != null) {
                command.add("--plugin=protoc-gen-" + this.nativePluginId + '=' + this.nativePluginExecutable);
            }
            outputOption = "--" + this.nativePluginId + "_out=";
            if (this.nativePluginParameter != null) {
                outputOption = outputOption + this.nativePluginParameter + ':';
            }
            outputOption = outputOption + this.customOutputDirectory;
            command.add(outputOption);
        }
        for (File protoFile : this.protoFiles) {
            command.add(protoFile.toString());
        }
        if (this.descriptorSetFile != null) {
            command.add("--descriptor_set_out=" + this.descriptorSetFile);
            if (this.includeImportsInDescriptorSet) {
                command.add("--include_imports");
            }
            if (this.includeSourceInfoInDescriptorSet) {
                command.add("--include_source_info");
            }
        }
        return ImmutableList.copyOf((Collection)command);
    }

    public void logExecutionParameters(Log log) {
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"[PROTOC] Executable: ");
            log.debug((CharSequence)("[PROTOC]  " + this.executable));
            if (this.protoPathElements != null && !this.protoPathElements.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Protobuf import paths:");
                for (File protoPathElement : this.protoPathElements) {
                    log.debug((CharSequence)("[PROTOC]  " + protoPathElement));
                }
            }
            if (this.javaOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Java output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.javaOutputDirectory));
                if (this.plugins.size() > 0) {
                    log.debug((CharSequence)"[PROTOC] Plugins for Java output:");
                    for (ProtocPlugin plugin : this.plugins) {
                        log.debug((CharSequence)("[PROTOC]  " + plugin.getId()));
                    }
                }
            }
            if (this.pluginDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Plugin directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pluginDirectory));
            }
            if (this.javaNanoOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Java Nano output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.javaNanoOutputDirectory));
            }
            if (this.cppOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] C++ output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.cppOutputDirectory));
            }
            if (this.pythonOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Python output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pythonOutputDirectory));
            }
            if (this.descriptorSetFile != null) {
                log.debug((CharSequence)"[PROTOC] Descriptor set output file:");
                log.debug((CharSequence)("[PROTOC]  " + this.descriptorSetFile));
                log.debug((CharSequence)"[PROTOC] Include imports:");
                log.debug((CharSequence)("[PROTOC]  " + this.includeImportsInDescriptorSet));
            }
            log.debug((CharSequence)"[PROTOC] Protobuf descriptors:");
            for (File protoFile : this.protoFiles) {
                log.debug((CharSequence)("[PROTOC]  " + protoFile));
            }
            ImmutableList<String> cl = this.buildProtocCommand();
            if (cl != null && !cl.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Command line options:");
                log.debug((CharSequence)(LOG_PREFIX + Joiner.on((char)' ').join(cl)));
            }
        }
    }

    public String getOutput() {
        return this.output.getOutput();
    }

    public String getError() {
        return this.error.getOutput();
    }

    static final class Builder {
        private final String executable;
        private final Set<File> protopathElements;
        private final Set<File> protoFiles;
        private final Set<ProtocPlugin> plugins;
        private File pluginDirectory;
        private String nativePluginId;
        private String nativePluginExecutable;
        private String nativePluginParameter;
        private File javaOutputDirectory;
        private File javaNanoOutputDirectory;
        private File cppOutputDirectory;
        private File pythonOutputDirectory;
        private File customOutputDirectory;
        private File descriptorSetFile;
        private boolean includeImportsInDescriptorSet;
        private boolean includeSourceInfoInDescriptorSet;

        Builder(String executable) {
            this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
            this.protoFiles = new LinkedHashSet<File>();
            this.protopathElements = new LinkedHashSet<File>();
            this.plugins = new LinkedHashSet<ProtocPlugin>();
        }

        public Builder setJavaOutputDirectory(File javaOutputDirectory) {
            this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory, (Object)"'javaOutputDirectory' is null");
            Preconditions.checkArgument((boolean)javaOutputDirectory.isDirectory(), (Object)("'javaOutputDirectory' is not a directory: " + javaOutputDirectory));
            return this;
        }

        public Builder setJavaNanoOutputDirectory(File javaNanoOutputDirectory) {
            this.javaNanoOutputDirectory = (File)Preconditions.checkNotNull((Object)javaNanoOutputDirectory, (Object)"'javaNanoOutputDirectory' is null");
            Preconditions.checkArgument((boolean)javaNanoOutputDirectory.isDirectory(), (Object)("'javaNanoOutputDirectory' is not a directory: " + javaNanoOutputDirectory));
            return this;
        }

        public Builder setCppOutputDirectory(File cppOutputDirectory) {
            this.cppOutputDirectory = (File)Preconditions.checkNotNull((Object)cppOutputDirectory, (Object)"'cppOutputDirectory' is null");
            Preconditions.checkArgument((boolean)cppOutputDirectory.isDirectory(), (Object)("'cppOutputDirectory' is not a directory: " + cppOutputDirectory));
            return this;
        }

        public Builder setPythonOutputDirectory(File pythonOutputDirectory) {
            this.pythonOutputDirectory = (File)Preconditions.checkNotNull((Object)pythonOutputDirectory, (Object)"'pythonOutputDirectory' is null");
            Preconditions.checkArgument((boolean)pythonOutputDirectory.isDirectory(), (Object)("'pythonOutputDirectory' is not a directory: " + pythonOutputDirectory));
            return this;
        }

        public Builder setCustomOutputDirectory(File customOutputDirectory) {
            this.customOutputDirectory = (File)Preconditions.checkNotNull((Object)customOutputDirectory, (Object)"'customOutputDirectory' is null");
            Preconditions.checkArgument((boolean)customOutputDirectory.isDirectory(), (Object)("'customOutputDirectory' is not a directory: " + customOutputDirectory));
            return this;
        }

        public Builder addProtoFile(File protoFile) {
            Preconditions.checkNotNull((Object)protoFile);
            Preconditions.checkArgument((boolean)protoFile.isFile());
            Preconditions.checkArgument((boolean)protoFile.getName().endsWith(".proto"));
            this.checkProtoFileIsInProtopath(protoFile);
            this.protoFiles.add(protoFile);
            return this;
        }

        public Builder addPlugin(ProtocPlugin plugin) {
            Preconditions.checkNotNull((Object)plugin);
            this.plugins.add(plugin);
            return this;
        }

        public Builder setPluginDirectory(File directory) {
            Preconditions.checkNotNull((Object)directory);
            Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)("Plugin directory " + directory + "does not exist"));
            this.pluginDirectory = directory;
            return this;
        }

        public void setNativePluginId(String nativePluginId) {
            Preconditions.checkNotNull((Object)nativePluginId, (Object)"'nativePluginId' is null");
            Preconditions.checkArgument((!nativePluginId.isEmpty() ? 1 : 0) != 0, (Object)"'nativePluginId' is empty");
            Preconditions.checkArgument((!nativePluginId.equals("java") && !nativePluginId.equals("javanano") && !nativePluginId.equals("python") && !nativePluginId.equals("cpp") && !nativePluginId.equals("descriptor_set") ? 1 : 0) != 0, (Object)"'nativePluginId' matches one of the built-in protoc plugins");
            this.nativePluginId = nativePluginId;
        }

        public void setNativePluginExecutable(String nativePluginExecutable) {
            Preconditions.checkNotNull((Object)nativePluginExecutable, (Object)"'nativePluginExecutable' is null");
            this.nativePluginExecutable = nativePluginExecutable;
        }

        public void setNativePluginParameter(String nativePluginParameter) {
            Preconditions.checkNotNull((Object)nativePluginParameter, (Object)"'nativePluginParameter' is null");
            Preconditions.checkArgument((!nativePluginParameter.contains(":") ? 1 : 0) != 0, (Object)"'nativePluginParameter' contains illegal characters");
            this.nativePluginParameter = nativePluginParameter;
        }

        public Builder withDescriptorSetFile(File descriptorSetFile, boolean includeImports, boolean includeSourceInfoInDescriptorSet) {
            Preconditions.checkNotNull((Object)descriptorSetFile, (Object)"descriptorSetFile");
            Preconditions.checkArgument((boolean)descriptorSetFile.getParentFile().isDirectory());
            this.descriptorSetFile = descriptorSetFile;
            this.includeImportsInDescriptorSet = includeImports;
            this.includeSourceInfoInDescriptorSet = includeSourceInfoInDescriptorSet;
            return this;
        }

        private void checkProtoFileIsInProtopath(File protoFile) {
            assert (protoFile.isFile());
            Preconditions.checkState((boolean)this.checkProtoFileIsInProtopathHelper(protoFile.getParentFile()));
        }

        private boolean checkProtoFileIsInProtopathHelper(File directory) {
            assert (directory.isDirectory());
            if (this.protopathElements.contains(directory)) {
                return true;
            }
            File parentDirectory = directory.getParentFile();
            return parentDirectory != null && this.checkProtoFileIsInProtopathHelper(parentDirectory);
        }

        public Builder addProtoFiles(Iterable<File> protoFiles) {
            for (File protoFile : protoFiles) {
                this.addProtoFile(protoFile);
            }
            return this;
        }

        public Builder addProtoPathElement(File protopathElement) {
            Preconditions.checkNotNull((Object)protopathElement);
            Preconditions.checkArgument((boolean)protopathElement.isDirectory());
            this.protopathElements.add(protopathElement);
            return this;
        }

        public Builder addProtoPathElements(Iterable<File> protopathElements) {
            for (File protopathElement : protopathElements) {
                this.addProtoPathElement(protopathElement);
            }
            return this;
        }

        private void validateState() {
            Preconditions.checkState((!this.protoFiles.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.javaOutputDirectory != null || this.javaNanoOutputDirectory != null || this.cppOutputDirectory != null || this.pythonOutputDirectory != null || this.customOutputDirectory != null ? 1 : 0) != 0, (Object)"At least one of these properties must be set: 'javaOutputDirectory', 'javaNanoOutputDirectory', 'cppOutputDirectory', 'pythonOutputDirectory' or 'customOutputDirectory'");
        }

        public Protoc build() {
            this.validateState();
            return new Protoc(this.executable, ImmutableSet.copyOf(this.protopathElements), ImmutableSet.copyOf(this.protoFiles), this.javaOutputDirectory, this.javaNanoOutputDirectory, this.cppOutputDirectory, this.pythonOutputDirectory, this.customOutputDirectory, this.descriptorSetFile, this.includeImportsInDescriptorSet, this.includeSourceInfoInDescriptorSet, ImmutableSet.copyOf(this.plugins), this.pluginDirectory, this.nativePluginId, this.nativePluginExecutable, this.nativePluginParameter);
        }
    }
}

