/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class DigestRandomGenerator
implements RandomGenerator {
    private long counter;
    private Digest digest;
    private byte[] state;

    public DigestRandomGenerator(Digest digest) {
        this.digest = digest;
        this.state = new byte[digest.getDigestSize()];
        this.counter = 1L;
    }

    public void addSeedMaterial(byte[] byArray) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            this.digestUpdate(byArray);
        }
    }

    public void addSeedMaterial(long l) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            int n = 0;
            while (n != 8) {
                this.digestUpdate((byte)l);
                l >>>= 8;
                ++n;
            }
        }
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            int n3 = 0;
            this.digestDoFinal(this.state);
            int n4 = n + n2;
            int n5 = n;
            while (n5 != n4) {
                if (n3 == this.state.length) {
                    this.digestUpdate(this.counter++);
                    this.digestUpdate(this.state);
                    this.digestDoFinal(this.state);
                    n3 = 0;
                }
                byArray[n5] = this.state[n3++];
                ++n5;
            }
            this.digestUpdate(this.counter++);
            this.digestUpdate(this.state);
        }
    }

    private void digestUpdate(long l) {
        int n = 0;
        while (n != 8) {
            this.digest.update((byte)l);
            l >>>= 8;
            ++n;
        }
    }

    private void digestUpdate(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    private void digestDoFinal(byte[] byArray) {
        this.digest.doFinal(byArray, 0);
    }
}

