/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;

public class TrustAnchor {
    private X509Certificate trustCert = null;
    private PublicKey trustPublicKey = null;
    private String trustName = null;
    private byte[] nameConstraints = null;

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) {
        if (x509Certificate == null) {
            throw new NullPointerException("trustedCert must be non-null");
        }
        this.trustCert = x509Certificate;
        if (byArray != null) {
            this.nameConstraints = (byte[])byArray.clone();
            this.checkNameConstraints(this.nameConstraints);
        }
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("caName must be non-null");
        }
        if (publicKey == null) {
            throw new NullPointerException("pubKey must be non-null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("caName can not be an empty string");
        }
        this.trustName = string;
        this.trustPublicKey = publicKey;
        if (byArray != null) {
            this.nameConstraints = (byte[])byArray.clone();
            this.checkNameConstraints(this.nameConstraints);
        }
    }

    public final X509Certificate getTrustedCert() {
        return this.trustCert;
    }

    public final String getCAName() {
        return this.trustName;
    }

    public final PublicKey getCAPublicKey() {
        return this.trustPublicKey;
    }

    public final byte[] getNameConstraints() {
        return (byte[])this.nameConstraints.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        if (this.getCAPublicKey() != null) {
            stringBuffer.append("  Trusted CA Public Key: ").append(this.getCAPublicKey()).append('\n');
            stringBuffer.append("  Trusted CA Issuer Name: ").append(this.getCAName()).append('\n');
        } else {
            stringBuffer.append("  Trusted CA cert: ").append(this.getTrustedCert()).append('\n');
        }
        if (this.nameConstraints != null) {
            stringBuffer.append("  Name Constraints: ").append(this.nameConstraints).append('\n');
        }
        return stringBuffer.toString();
    }

    private void checkNameConstraints(byte[] byArray) {
        if (byArray != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
                DERObject dERObject = dERInputStream.readObject();
                if (!(dERObject instanceof ASN1Sequence)) {
                    throw new IllegalArgumentException("nameConstraints parameter decoding error");
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("nameConstraints parameter decoding error: " + iOException);
            }
        }
    }
}

