/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.voms;

import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.IetfAttrSyntax;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertificate;

public class VOMSAttribute {
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private X509AttributeCertificate myAC;
    private String myHostPort;
    private String myVo;
    private Vector myStringList = new Vector();
    private Vector myFQANs = new Vector();

    public VOMSAttribute(X509AttributeCertificate x509AttributeCertificate) {
        if (x509AttributeCertificate == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.myAC = x509AttributeCertificate;
        X509Attribute[] x509AttributeArray = x509AttributeCertificate.getAttributes(VOMS_ATTR_OID);
        if (x509AttributeArray == null) {
            return;
        }
        try {
            int n = 0;
            while (n != x509AttributeArray.length) {
                IetfAttrSyntax ietfAttrSyntax = new IetfAttrSyntax((ASN1Sequence)x509AttributeArray[n].getValues()[0]);
                String string = ((DERIA5String)GeneralName.getInstance(((ASN1Sequence)ietfAttrSyntax.getPolicyAuthority().getDERObject()).getObjectAt(0)).getName()).getString();
                int n2 = string.indexOf("://");
                if (n2 < 0 || n2 == string.length() - 1) {
                    throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + string + "]");
                }
                this.myVo = string.substring(0, n2);
                this.myHostPort = string.substring(n2 + 3);
                if (ietfAttrSyntax.getValueType() != 1) {
                    throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + string);
                }
                ASN1OctetString[] aSN1OctetStringArray = (ASN1OctetString[])ietfAttrSyntax.getValues();
                int n3 = 0;
                while (n3 != aSN1OctetStringArray.length) {
                    String string2 = new String(aSN1OctetStringArray[n3].getOctets());
                    FQAN fQAN = new FQAN(string2);
                    if (!this.myStringList.contains(string2) && string2.startsWith("/" + this.myVo + "/")) {
                        this.myStringList.add(string2);
                        this.myFQANs.add(fQAN);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Badly encoded VOMS extension in AC issued by " + x509AttributeCertificate.getIssuer());
        }
    }

    public X509AttributeCertificate getAC() {
        return this.myAC;
    }

    public List getFullyQualifiedAttributes() {
        return this.myStringList;
    }

    public List getListOfFQAN() {
        return this.myFQANs;
    }

    public String getHostPort() {
        return this.myHostPort;
    }

    public String getVO() {
        return this.myVo;
    }

    public String toString() {
        return "VO      :" + this.myVo + "\n" + "HostPort:" + this.myHostPort + "\n" + "FQANs   :" + this.myFQANs;
    }

    public class FQAN {
        String fqan;
        String group;
        String role;
        String capability;

        public FQAN(String string) {
            this.fqan = string;
        }

        public FQAN(String string, String string2, String string3) {
            this.group = string;
            this.role = string2;
            this.capability = string3;
        }

        public String getFQAN() {
            if (this.fqan != null) {
                return this.fqan;
            }
            this.fqan = this.group + "/Role=" + (this.role != null ? this.role : "") + (this.capability != null ? "/Capability=" + this.capability : "");
            return this.fqan;
        }

        protected void split() {
            int n = this.fqan.length();
            int n2 = this.fqan.indexOf("/Role=");
            if (n2 < 0) {
                return;
            }
            this.group = this.fqan.substring(0, n2);
            int n3 = this.fqan.indexOf("/Capability=", n2 + 6);
            String string = n3 < 0 ? this.fqan.substring(n2 + 6) : this.fqan.substring(n2 + 6, n3);
            this.role = string.length() == 0 ? null : string;
            string = n3 < 0 ? null : this.fqan.substring(n3 + 12);
            this.capability = string == null || string.length() == 0 ? null : string;
        }

        public String getGroup() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.group;
        }

        public String getRole() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.role;
        }

        public String getCapability() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.capability;
        }

        public String toString() {
            return this.getFQAN();
        }
    }
}

