/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.mail.core;

import java.beans.PropertyEditorSupport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class InternetAddressEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (InternetAddressEditor.hasText(text)) {
            try {
                this.setValue(new InternetAddress(text));
            }
            catch (AddressException ex) {
                throw new IllegalArgumentException("Could not parse mail address: " + ex.getMessage());
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        InternetAddress value = (InternetAddress)this.getValue();
        return value != null ? value.toUnicodeString() : "";
    }

    public static boolean hasText(CharSequence str) {
        if (!InternetAddressEditor.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }
}

