/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.mail.core;

import com.jfplugin.mail.core.Assert;
import com.jfplugin.mail.core.MailMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public class SimpleMailMessage
implements MailMessage,
Serializable {
    private static final long serialVersionUID = -2920330500439593437L;
    private String from;
    private String replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private Date sentDate;
    private String subject;
    private String text;

    public SimpleMailMessage() {
    }

    public SimpleMailMessage(SimpleMailMessage original) {
        Assert.notNull(original, "The 'original' message argument cannot be null");
        this.from = original.getFrom();
        this.replyTo = original.getReplyTo();
        if (original.getTo() != null) {
            this.to = SimpleMailMessage.copy(original.getTo());
        }
        if (original.getCc() != null) {
            this.cc = SimpleMailMessage.copy(original.getCc());
        }
        if (original.getBcc() != null) {
            this.bcc = SimpleMailMessage.copy(original.getBcc());
        }
        this.sentDate = original.getSentDate();
        this.subject = original.getSubject();
        this.text = original.getText();
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setTo(String to) {
        this.to = new String[]{to};
    }

    @Override
    public void setTo(String[] to) {
        this.to = to;
    }

    public String[] getTo() {
        return this.to;
    }

    @Override
    public void setCc(String cc) {
        this.cc = new String[]{cc};
    }

    @Override
    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public String[] getCc() {
        return this.cc;
    }

    @Override
    public void setBcc(String bcc) {
        this.bcc = new String[]{bcc};
    }

    @Override
    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    @Override
    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void copyTo(MailMessage target) {
        Assert.notNull(target, "The 'target' message argument cannot be null");
        if (this.getFrom() != null) {
            target.setFrom(this.getFrom());
        }
        if (this.getReplyTo() != null) {
            target.setReplyTo(this.getReplyTo());
        }
        if (this.getTo() != null) {
            target.setTo(this.getTo());
        }
        if (this.getCc() != null) {
            target.setCc(this.getCc());
        }
        if (this.getBcc() != null) {
            target.setBcc(this.getBcc());
        }
        if (this.getSentDate() != null) {
            target.setSentDate(this.getSentDate());
        }
        if (this.getSubject() != null) {
            target.setSubject(this.getSubject());
        }
        if (this.getText() != null) {
            target.setText(this.getText());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleMailMessage: ");
        sb.append("from=").append(this.from).append("; ");
        sb.append("replyTo=").append(this.replyTo).append("; ");
        sb.append("to=").append(SimpleMailMessage.arrayToCommaDelimitedString(this.to)).append("; ");
        sb.append("cc=").append(SimpleMailMessage.arrayToCommaDelimitedString(this.cc)).append("; ");
        sb.append("bcc=").append(SimpleMailMessage.arrayToCommaDelimitedString(this.bcc)).append("; ");
        sb.append("sentDate=").append(this.sentDate).append("; ");
        sb.append("subject=").append(this.subject).append("; ");
        sb.append("text=").append(this.text);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleMailMessage)) {
            return false;
        }
        SimpleMailMessage otherMessage = (SimpleMailMessage)other;
        return SimpleMailMessage.nullSafeEquals(this.from, otherMessage.from) && SimpleMailMessage.nullSafeEquals(this.replyTo, otherMessage.replyTo) && Arrays.equals(this.to, otherMessage.to) && Arrays.equals(this.cc, otherMessage.cc) && Arrays.equals(this.bcc, otherMessage.bcc) && SimpleMailMessage.nullSafeEquals(this.sentDate, otherMessage.sentDate) && SimpleMailMessage.nullSafeEquals(this.subject, otherMessage.subject) && SimpleMailMessage.nullSafeEquals(this.text, otherMessage.text);
    }

    public int hashCode() {
        int i;
        int hashCode = this.from == null ? 0 : this.from.hashCode();
        hashCode = 29 * hashCode + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        for (i = 0; this.to != null && i < this.to.length; ++i) {
            hashCode = 29 * hashCode + (this.to == null ? 0 : this.to[i].hashCode());
        }
        for (i = 0; this.cc != null && i < this.cc.length; ++i) {
            hashCode = 29 * hashCode + (this.cc == null ? 0 : this.cc[i].hashCode());
        }
        for (i = 0; this.bcc != null && i < this.bcc.length; ++i) {
            hashCode = 29 * hashCode + (this.bcc == null ? 0 : this.bcc[i].hashCode());
        }
        hashCode = 29 * hashCode + (this.sentDate == null ? 0 : this.sentDate.hashCode());
        hashCode = 29 * hashCode + (this.subject == null ? 0 : this.subject.hashCode());
        hashCode = 29 * hashCode + (this.text == null ? 0 : this.text.hashCode());
        return hashCode;
    }

    private static String[] copy(String[] state) {
        String[] copy = new String[state.length];
        System.arraycopy(state, 0, copy, 0, state.length);
        return copy;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return Arrays.equals((Object[])o1, (Object[])o2);
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
        }
        return false;
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return SimpleMailMessage.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return SimpleMailMessage.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return SimpleMailMessage.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return SimpleMailMessage.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return SimpleMailMessage.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return SimpleMailMessage.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return SimpleMailMessage.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return SimpleMailMessage.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return SimpleMailMessage.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return SimpleMailMessage.arrayToDelimitedString(arr, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (SimpleMailMessage.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return SimpleMailMessage.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }
}

