/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.mutable.MutableObj;
import java.util.Iterator;
import java.util.WeakHashMap;

public class WeakCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    TimedCache<MutableObj<K>, V> timedCache;

    public WeakCache(long timeout) {
        this.timedCache = new TimedCache(timeout, new WeakHashMap());
    }

    @Override
    public int capacity() {
        return this.timedCache.capacity();
    }

    @Override
    public long timeout() {
        return this.timedCache.timeout();
    }

    @Override
    public void put(K key, V object) {
        this.timedCache.put(new MutableObj(key), object);
    }

    @Override
    public void put(K key, V object, long timeout) {
        this.timedCache.put(new MutableObj(key), object, timeout);
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess, Func0<V> supplier) {
        return this.timedCache.get(new MutableObj(key), isUpdateLastAccess, supplier);
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        return this.timedCache.get(new MutableObj(key), isUpdateLastAccess);
    }

    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        final Iterator timedIter = this.timedCache.cacheObjIterator();
        return new Iterator<CacheObj<K, V>>(){

            @Override
            public boolean hasNext() {
                return timedIter.hasNext();
            }

            @Override
            public CacheObj<K, V> next() {
                CacheObj next = (CacheObj)timedIter.next();
                CacheObj nextNew = new CacheObj(((MutableObj)next.key).get(), next.obj, next.ttl);
                nextNew.lastAccess = next.lastAccess;
                nextNew.accessCount = next.accessCount;
                return nextNew;
            }
        };
    }

    @Override
    public int prune() {
        return this.timedCache.prune();
    }

    @Override
    public boolean isFull() {
        return this.timedCache.isFull();
    }

    @Override
    public void remove(K key) {
        this.timedCache.remove(new MutableObj(key));
    }

    @Override
    public void clear() {
        this.timedCache.clear();
    }

    @Override
    public int size() {
        return this.timedCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.timedCache.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.timedCache.containsKey(new MutableObj(key));
    }

    @Override
    public Iterator<V> iterator() {
        return this.timedCache.iterator();
    }
}

