/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.okhttps.internal.StreamRequestBody;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class FilePara {
    private final String type;
    private final String fileName;
    private final byte[] content;
    private final File file;
    private final InputStream stream;

    public FilePara(String type, String fileName, byte[] content) {
        this(type, fileName, null, content, null);
    }

    public FilePara(String type, String fileName, File file) {
        this(type, fileName, file, null, null);
    }

    public FilePara(String type, String fileName, InputStream stream) {
        this(type, fileName, null, null, stream);
    }

    private FilePara(String type, String fileName, File file, byte[] content, InputStream stream) {
        this.type = type;
        this.fileName = fileName;
        this.file = file;
        this.content = content;
        this.stream = stream;
    }

    public RequestBody toRequestBody(MediaType contentType) {
        if (this.file != null) {
            return RequestBody.create((MediaType)contentType, (File)this.file);
        }
        if (this.content != null) {
            return RequestBody.create((MediaType)contentType, (byte[])this.content);
        }
        if (this.stream != null) {
            return new StreamRequestBody(contentType, this.stream);
        }
        throw new IllegalStateException("Invalid FilePara");
    }

    public String getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getContent() {
        return this.content;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return "FilePara{type='" + this.type + '\'' + ", fileName='" + this.fileName + '\'' + ", content=" + Arrays.toString(this.content) + ", file=" + this.file + ", stream=" + this.stream + '}';
    }
}

