/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class Platform {
    public static final int ANDROID_SDK_INT = Platform.getAndroidSdkInt();
    private static Method logMethod = null;
    private static String okHttpVersion;

    private static int getAndroidSdkInt() {
        try {
            Class<?> versionClass = Class.forName("android.os.Build$VERSION");
            Field field = versionClass.getDeclaredField("SDK_INT");
            return field.getInt(field);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
    }

    public static void logInfo(String message) {
        Platform.doLog(4, message, null);
    }

    public static void logError(String message) {
        Platform.logError(message, null);
    }

    public static void logError(String message, Throwable t) {
        Platform.doLog(5, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLog(int level, String message, Throwable t) {
        okhttp3.internal.platform.Platform platform = okhttp3.internal.platform.Platform.get();
        if (Platform.isOkHttpVersionLessThan4()) {
            platform.log(level, message, t);
            return;
        }
        try {
            Class<Platform> clazz = Platform.class;
            synchronized (Platform.class) {
                if (logMethod == null) {
                    logMethod = platform.getClass().getMethod("log", String.class, Integer.TYPE, Throwable.class);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                logMethod.invoke((Object)platform, message, level, t);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static boolean isOkHttpVersionLessThan4() {
        if (okHttpVersion == null) {
            try {
                Class<?> versionClass = Class.forName("okhttp3.internal.Version");
                Method method = versionClass.getDeclaredMethod("userAgent", new Class[0]);
                okHttpVersion = (String)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                okHttpVersion = "4.x";
            }
        }
        return !okHttpVersion.startsWith("4");
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !Platform.isBlank(str);
    }
}

