/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps.internal;

import cn.zhxu.okhttps.Process;

public class RealProcess
implements Process {
    private final long totalBytes;
    private long doneBytes;

    public RealProcess(long totalBytes, long doneBytes) {
        this.totalBytes = totalBytes;
        this.doneBytes = doneBytes;
    }

    public Process newProcess() {
        return new RealProcess(this.totalBytes, this.doneBytes);
    }

    @Override
    public double getRate() {
        if (this.totalBytes == 0L) {
            return 1.0;
        }
        if (this.totalBytes < 0L) {
            return -1.0;
        }
        return (double)this.doneBytes / (double)this.totalBytes;
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public long getDoneBytes() {
        return this.doneBytes;
    }

    @Override
    public boolean isDone() {
        return this.doneBytes >= this.totalBytes && this.totalBytes >= 0L;
    }

    public void addDoneBytes(long delt) {
        this.doneBytes += delt;
    }

    public boolean isUndoneAndUnreached(long bytes) {
        return this.doneBytes < bytes && (this.totalBytes < 0L || this.doneBytes < this.totalBytes);
    }

    public String toString() {
        return "Process[" + this.doneBytes + " / " + this.totalBytes + " | " + this.getRate() + ']';
    }
}

