/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.job.task.dto.JobPartitionTaskDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class JobLogMergeSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(JobLogMergeSchedule.class);
    private final SystemProperties systemProperties;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobLogMessageMapper jobLogMessageMapper;
    private final TransactionTemplate transactionTemplate;
    private static Long lastMergeLogTime = 0L;

    public String lockName() {
        return "jobLogMerge";
    }

    public String lockAtMost() {
        return "PT1H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        try {
            if (System.currentTimeMillis() - lastMergeLogTime < 86400000L) {
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getMergeLogDays());
            long total = PartitionTaskUtils.process(startId -> this.jobTaskBatchList(startId, endTime), this::processJobLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("job merge success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("job merge log error", new Object[]{e});
        }
        finally {
            lastMergeLogTime = System.currentTimeMillis();
        }
    }

    private List<JobPartitionTaskDTO> jobTaskBatchList(Long startId, LocalDateTime endTime) {
        List jobTaskBatchList = ((Page)this.jobTaskBatchMapper.selectPage((IPage)new Page(0L, 1000L), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(JobTaskBatch::getId, (Object)startId)).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.COMPLETED)).le(CreateDt::getCreateDt, (Object)endTime)).orderByAsc(JobTaskBatch::getId))).getRecords();
        return JobTaskConverter.INSTANCE.toJobTaskBatchPartitionTasks(jobTaskBatchList);
    }

    public void processJobLogPartitionTasks(List<? extends PartitionTask> partitionTasks) {
        List ids = StreamUtils.toList(partitionTasks, PartitionTask::getId);
        if (CollUtil.isEmpty((Collection)ids)) {
            return;
        }
        List jobLogMessageList = this.jobLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().in(JobLogMessage::getTaskBatchId, (Collection)ids));
        if (CollUtil.isEmpty((Collection)jobLogMessageList)) {
            return;
        }
        List jobLogMessageGroupList = jobLogMessageList.stream().collect(Collectors.groupingBy(JobLogMessage::getTaskId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() >= 2).collect(Collectors.toList());
        for (Map.Entry jobLogMessageMap : jobLogMessageGroupList) {
            final ArrayList jobLogMessageDeleteBatchIds = new ArrayList();
            final ArrayList<JobLogMessage> jobLogMessageInsertBatchIds = new ArrayList<JobLogMessage>();
            List mergeMessages = ((List)jobLogMessageMap.getValue()).stream().map(k -> {
                jobLogMessageDeleteBatchIds.add(k.getId());
                return (List)JsonUtil.parseObject((String)k.getMessage(), List.class);
            }).reduce((a, b) -> {
                ArrayList list = new ArrayList();
                list.addAll(a);
                list.addAll(b);
                return list;
            }).get();
            List partitionMessages = Lists.partition((List)mergeMessages, (int)this.systemProperties.getMergeLogNum());
            for (List partitionMessage : partitionMessages) {
                JobLogMessage jobLogMessage = JobTaskConverter.INSTANCE.toJobLogMessage((JobLogMessage)((List)jobLogMessageMap.getValue()).get(0));
                jobLogMessage.setLogNum(Integer.valueOf(partitionMessage.size()));
                jobLogMessage.setMessage(JsonUtil.toJsonString((Object)partitionMessage));
                jobLogMessageInsertBatchIds.add(jobLogMessage);
            }
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    List partition;
                    if (CollUtil.isNotEmpty((Collection)jobLogMessageDeleteBatchIds)) {
                        partition = Lists.partition((List)jobLogMessageDeleteBatchIds, (int)500);
                        for (List mid : partition) {
                            JobLogMergeSchedule.this.jobLogMessageMapper.deleteByIds((Collection)mid);
                        }
                    }
                    if (CollUtil.isNotEmpty((Collection)jobLogMessageInsertBatchIds)) {
                        partition = Lists.partition((List)jobLogMessageInsertBatchIds, (int)500);
                        for (List jobLogMessages : partition) {
                            JobLogMergeSchedule.this.jobLogMessageMapper.insertBatch(jobLogMessages);
                        }
                    }
                }
            });
        }
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((JobLogMergeSchedule)this).execute(), Duration.parse("PT1H"));
    }

    public void close() {
    }

    public JobLogMergeSchedule(SystemProperties systemProperties, JobTaskBatchMapper jobTaskBatchMapper, JobLogMessageMapper jobLogMessageMapper, TransactionTemplate transactionTemplate) {
        this.systemProperties = systemProperties;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobLogMessageMapper = jobLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
    }
}

