/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.LoginUser;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.SystemUpdateUserPasswordRequestVO;
import com.aizuda.snailjob.server.web.model.request.SystemUserQueryVO;
import com.aizuda.snailjob.server.web.model.request.SystemUserRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.PermissionsResponseVO;
import com.aizuda.snailjob.server.web.model.response.SystemUserResponseVO;
import com.aizuda.snailjob.server.web.service.SystemUserService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemUserController {
    private static final Long SUPER_ADMIN_ID = 1L;
    private final SystemUserService systemUserService;

    @PostMapping(value={"/auth/login"})
    public SystemUserResponseVO login(@RequestBody SystemUserRequestVO requestVO) {
        return this.systemUserService.login(requestVO);
    }

    @LoginRequired
    @GetMapping(value={"/user/info"})
    public SystemUserResponseVO getUserInfo(@LoginUser UserSessionVO systemUser) {
        return this.systemUserService.getUserInfo(systemUser);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PostMapping(value={"/user"})
    public void addUser(@RequestBody @Valid SystemUserRequestVO requestVO) {
        this.systemUserService.addUser(requestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user/page/list"})
    public PageResult<List<SystemUserResponseVO>> getSystemUserPageList(SystemUserQueryVO systemUserQueryVO) {
        return this.systemUserService.getSystemUserPageList(systemUserQueryVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PutMapping(value={"/user"})
    public void update(@RequestBody @Valid SystemUserRequestVO requestVO) {
        if (SUPER_ADMIN_ID.equals(requestVO.getId()) && RoleEnum.isUser(requestVO.getRole())) {
            throw new SnailJobServerException("\u4e0d\u5141\u8bb8\u4fee\u6539\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272");
        }
        this.systemUserService.update(requestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user/username/user-info"})
    public SystemUserResponseVO getSystemUserByUserName(@RequestParam(value="username") String username) {
        return this.systemUserService.getSystemUserByUserName(username);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user-permissions/{id}"})
    public List<PermissionsResponseVO> getSystemUserPermissionByUserName(@PathVariable(value="id") Long id) {
        return this.systemUserService.getSystemUserPermissionByUserName(id);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @DeleteMapping(value={"/user/{id}"})
    public boolean delUser(@PathVariable(value="id") Long id) {
        if (SUPER_ADMIN_ID.equals(id)) {
            throw new SnailJobServerException("\u4e0d\u5141\u8bb8\u5220\u9664\u8d85\u7ea7\u7ba1\u7406\u5458");
        }
        return this.systemUserService.delUser(id);
    }

    @LoginRequired
    @PutMapping(value={"/update-user-password"})
    public void updateUserPassword(@RequestBody @Valid SystemUpdateUserPasswordRequestVO requestVO) {
        this.systemUserService.updateUserPassword(requestVO);
    }

    public SystemUserController(SystemUserService systemUserService) {
        this.systemUserService = systemUserService;
    }
}

