/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.CallbackConfig;
import com.aizuda.snailjob.server.common.dto.DecisionConfig;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobBatchQueryVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.JobBatchResponseVO;
import com.aizuda.snailjob.server.web.service.JobBatchService;
import com.aizuda.snailjob.server.web.service.convert.JobBatchResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.JobHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobBatchServiceImpl
implements JobBatchService {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobMapper jobMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobHandler jobHandler;

    @Override
    public PageResult<List<JobBatchResponseVO>> getJobBatchPage(JobBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        if (userSessionVO.isUser() && CollUtil.isEmpty(groupNames)) {
            return new PageResult<List<JobBatchResponseVO>>(pageDTO, Collections.emptyList());
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"batch.namespace_id", (Object)userSessionVO.getNamespaceId())).eq((Object)"batch.system_task_type", (Object)SyetemTaskTypeEnum.JOB.getType())).eq(queryVO.getJobId() != null, (Object)"batch.job_id", (Object)queryVO.getJobId())).in(CollUtil.isNotEmpty(groupNames), (Object)"batch.group_name", groupNames)).eq(queryVO.getTaskBatchStatus() != null, (Object)"batch.task_batch_status", (Object)queryVO.getTaskBatchStatus())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getJobName()), (Object)"job.job_name", (Object)queryVO.getJobName())).between(ObjUtil.isAllNotEmpty((Object[])new Object[]{queryVO.getStartDt(), queryVO.getEndDt()}), (Object)"batch.create_dt", (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).eq((Object)"batch.deleted", (Object)0)).orderByDesc((Object)"batch.id");
        List batchResponseDOList = this.jobTaskBatchMapper.selectJobBatchPageList((IPage)pageDTO, (Wrapper)wrapper);
        List<JobBatchResponseVO> batchResponseVOList = JobBatchResponseVOConverter.INSTANCE.convertList(batchResponseDOList);
        return new PageResult<List<JobBatchResponseVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public JobBatchResponseVO getJobBatchDetail(Long id) {
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectById((Serializable)id);
        if (Objects.isNull(jobTaskBatch)) {
            return null;
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        JobBatchResponseVO jobBatchResponseVO = JobBatchResponseVOConverter.INSTANCE.convert(jobTaskBatch, job);
        if (jobTaskBatch.getSystemTaskType().equals(SyetemTaskTypeEnum.WORKFLOW.getType())) {
            WorkflowNode workflowNode = (WorkflowNode)this.workflowNodeMapper.selectById((Serializable)jobTaskBatch.getWorkflowNodeId());
            jobBatchResponseVO.setNodeName(workflowNode.getNodeName());
            if (SystemConstants.CALLBACK_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setCallback((CallbackConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), CallbackConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return jobBatchResponseVO;
            }
            if (SystemConstants.DECISION_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setDecision((DecisionConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return jobBatchResponseVO;
            }
        }
        return jobBatchResponseVO;
    }

    @Override
    public boolean stop(Long taskBatchId) {
        return this.jobHandler.stop(taskBatchId);
    }

    @Override
    @Transactional
    public Boolean retry(Long taskBatchId) {
        return this.jobHandler.retry(taskBatchId);
    }

    @Override
    public Boolean deleteJobBatchByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        this.jobHandler.deleteJobTaskBatchByIds(ids, namespaceId);
        return Boolean.TRUE;
    }

    public JobBatchServiceImpl(JobTaskBatchMapper jobTaskBatchMapper, JobMapper jobMapper, WorkflowNodeMapper workflowNodeMapper, JobHandler jobHandler) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobHandler = jobHandler;
    }
}

