/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosPropertiesBuilder;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class NacosConfigLoader {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigLoader.class);
    private final NacosConfigProperties nacosConfigProperties;
    private final Properties globalProperties;
    private final ConfigurableEnvironment environment;
    private Function<Properties, ConfigService> builder;
    private List<DeferNacosPropertySource> nacosPropertySources = new LinkedList<DeferNacosPropertySource>();

    public NacosConfigLoader(NacosConfigProperties nacosConfigProperties, ConfigurableEnvironment environment, Function<Properties, ConfigService> builder) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.environment = environment;
        this.builder = builder;
        this.globalProperties = this.buildGlobalNacosProperties();
    }

    public void loadConfig() {
        MutablePropertySources mutablePropertySources = this.environment.getPropertySources();
        List<NacosPropertySource> sources = this.reqGlobalNacosConfig(this.globalProperties, this.nacosConfigProperties.getType());
        for (NacosConfigProperties.Config config : this.nacosConfigProperties.getExtConfig()) {
            List<NacosPropertySource> elements = this.reqSubNacosConfig(config, this.globalProperties, config.getType());
            sources.addAll(elements);
        }
        if (this.nacosConfigProperties.isRemoteFirst()) {
            ListIterator<NacosPropertySource> itr = sources.listIterator(sources.size());
            while (itr.hasPrevious()) {
                mutablePropertySources.addAfter("systemEnvironment", (PropertySource)itr.previous());
            }
        } else {
            for (NacosPropertySource propertySource : sources) {
                mutablePropertySources.addLast((PropertySource)propertySource);
            }
        }
    }

    public Properties buildGlobalNacosProperties() {
        return NacosPropertiesBuilder.buildNacosProperties((Environment)this.environment, this.nacosConfigProperties.getServerAddr(), this.nacosConfigProperties.getNamespace(), this.nacosConfigProperties.getEndpoint(), this.nacosConfigProperties.getSecretKey(), this.nacosConfigProperties.getAccessKey(), this.nacosConfigProperties.getRamRoleName(), this.nacosConfigProperties.getConfigLongPollTimeout(), this.nacosConfigProperties.getConfigRetryTime(), this.nacosConfigProperties.getMaxRetry(), this.nacosConfigProperties.isEnableRemoteSyncConfig(), this.nacosConfigProperties.getUsername(), this.nacosConfigProperties.getPassword());
    }

    private Properties buildSubNacosProperties(Properties globalProperties, NacosConfigProperties.Config config) {
        Properties sub = NacosPropertiesBuilder.buildNacosProperties((Environment)this.environment, config.getServerAddr(), config.getNamespace(), config.getEndpoint(), config.getSecretKey(), config.getAccessKey(), config.getRamRoleName(), config.getConfigLongPollTimeout(), config.getConfigRetryTime(), config.getMaxRetry(), config.isEnableRemoteSyncConfig(), config.getUsername(), config.getPassword());
        NacosPropertiesBuilder.merge(sub, globalProperties);
        return sub;
    }

    private List<NacosPropertySource> reqGlobalNacosConfig(Properties globalProperties, ConfigType type) {
        ArrayList<String> dataIds = new ArrayList<String>();
        if (!StringUtils.hasLength((String)this.nacosConfigProperties.getDataId())) {
            String ids = this.environment.resolvePlaceholders(this.nacosConfigProperties.getDataIds());
            dataIds.addAll(Arrays.asList(ids.split(",")));
        } else {
            dataIds.add(this.nacosConfigProperties.getDataId());
        }
        String groupName = this.environment.resolvePlaceholders(this.nacosConfigProperties.getGroup());
        boolean isAutoRefresh = this.nacosConfigProperties.isAutoRefresh();
        return new ArrayList<NacosPropertySource>(Arrays.asList(this.reqNacosConfig(globalProperties, dataIds.toArray(new String[0]), groupName, type, isAutoRefresh)));
    }

    private List<NacosPropertySource> reqSubNacosConfig(NacosConfigProperties.Config config, Properties globalProperties, ConfigType type) {
        Properties subConfigProperties = this.buildSubNacosProperties(globalProperties, config);
        ArrayList<String> dataIds = new ArrayList<String>();
        if (!StringUtils.hasLength((String)config.getDataId())) {
            String ids = this.environment.resolvePlaceholders(config.getDataIds());
            dataIds.addAll(Arrays.asList(ids.split(",")));
        } else {
            dataIds.add(config.getDataId());
        }
        String groupName = this.environment.resolvePlaceholders(config.getGroup());
        boolean isAutoRefresh = config.isAutoRefresh();
        return new ArrayList<NacosPropertySource>(Arrays.asList(this.reqNacosConfig(subConfigProperties, dataIds.toArray(new String[0]), groupName, type, isAutoRefresh)));
    }

    private NacosPropertySource[] reqNacosConfig(Properties configProperties, String[] dataIds, String groupId, ConfigType type, boolean isAutoRefresh) {
        NacosPropertySource[] propertySources = new NacosPropertySource[dataIds.length];
        for (int i = 0; i < dataIds.length; ++i) {
            if (!StringUtils.hasLength((String)dataIds[i])) continue;
            String dataId = this.environment.resolvePlaceholders(dataIds[i].trim());
            String config = NacosUtils.getContent((ConfigService)this.builder.apply(configProperties), (String)dataId, (String)groupId);
            NacosPropertySource nacosPropertySource = new NacosPropertySource(dataId, groupId, NacosUtils.buildDefaultPropertySourceName((String)dataId, (String)groupId, (Map)configProperties), config, type.getType());
            nacosPropertySource.setDataId(dataId);
            nacosPropertySource.setType(type.getType());
            nacosPropertySource.setGroupId(groupId);
            nacosPropertySource.setAutoRefreshed(isAutoRefresh);
            this.logger.info("load config from nacos, data-id is : {}, group is : {}", (Object)nacosPropertySource.getDataId(), (Object)nacosPropertySource.getGroupId());
            propertySources[i] = nacosPropertySource;
            DeferNacosPropertySource defer = new DeferNacosPropertySource(nacosPropertySource, configProperties, this.environment);
            this.nacosPropertySources.add(defer);
        }
        return propertySources;
    }

    public void addListenerIfAutoRefreshed() {
        this.addListenerIfAutoRefreshed(this.nacosPropertySources);
    }

    public void addListenerIfAutoRefreshed(List<DeferNacosPropertySource> deferNacosPropertySources) {
        for (DeferNacosPropertySource deferNacosPropertySource : deferNacosPropertySources) {
            NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed((NacosPropertySource)deferNacosPropertySource.getNacosPropertySource(), (Properties)deferNacosPropertySource.getProperties(), (ConfigurableEnvironment)deferNacosPropertySource.getEnvironment());
        }
    }

    public List<DeferNacosPropertySource> getNacosPropertySources() {
        return this.nacosPropertySources;
    }

    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    public static class DeferNacosPropertySource {
        private final NacosPropertySource nacosPropertySource;
        private final ConfigurableEnvironment environment;
        private final Properties properties;

        DeferNacosPropertySource(NacosPropertySource nacosPropertySource, Properties properties, ConfigurableEnvironment environment) {
            this.nacosPropertySource = nacosPropertySource;
            this.properties = properties;
            this.environment = environment;
        }

        NacosPropertySource getNacosPropertySource() {
            return this.nacosPropertySource;
        }

        ConfigurableEnvironment getEnvironment() {
            return this.environment;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

