/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.agent;

import com.alibaba.cloud.ai.agent.Agent;
import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgentOptions;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAgentApi;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class DashScopeAgent
extends Agent {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeAgent.class);
    public static final String REQUEST_ID = "request_id";
    public static final String USAGE = "usage";
    public static final String OUTPUT = "output";
    private final DashScopeAgentOptions options;
    private final DashScopeAgentApi dashScopeAgentApi;

    public DashScopeAgent(DashScopeAgentApi dashScopeAgentApi) {
        this.dashScopeAgentApi = dashScopeAgentApi;
        this.options = DashScopeAgentOptions.builder().withSessionId(null).withMemoryId(null).withIncrementalOutput(false).withHasThoughts(false).withBizParams(null).build();
    }

    public DashScopeAgent(DashScopeAgentApi dashScopeAgentApi, DashScopeAgentOptions options) {
        this.dashScopeAgentApi = dashScopeAgentApi;
        this.options = options;
    }

    @Override
    public ChatResponse call(Prompt prompt) {
        DashScopeAgentApi.DashScopeAgentRequest request = this.toRequest(prompt, false);
        ResponseEntity<DashScopeAgentApi.DashScopeAgentResponse> response = this.dashScopeAgentApi.call(request);
        if (response == null || response.getBody() == null) {
            logger.warn("app call error: request: {}", (Object)request);
            return null;
        }
        return this.toChatResponse((DashScopeAgentApi.DashScopeAgentResponse)response.getBody());
    }

    @Override
    public Flux<ChatResponse> stream(Prompt prompt) {
        DashScopeAgentApi.DashScopeAgentRequest request = this.toRequest(prompt, true);
        Flux<DashScopeAgentApi.DashScopeAgentResponse> response = this.dashScopeAgentApi.stream(request);
        return Flux.from(response).flatMap(result -> Flux.just((Object)this.toChatResponse((DashScopeAgentApi.DashScopeAgentResponse)result))).publishOn(Schedulers.parallel());
    }

    private DashScopeAgentApi.DashScopeAgentRequest toRequest(Prompt prompt, Boolean stream) {
        if (prompt == null || prompt.getOptions() == null) {
            throw new IllegalArgumentException("option is null");
        }
        String appId = null;
        ChatOptions chatOptions = prompt.getOptions();
        if (chatOptions instanceof DashScopeAgentOptions) {
            DashScopeAgentOptions options = (DashScopeAgentOptions)chatOptions;
            appId = options.getAppId();
        }
        if (appId == null) {
            throw new IllegalArgumentException("appId must be set");
        }
        return new DashScopeAgentApi.DashScopeAgentRequest(appId, new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestInput(prompt.getContents(), this.options.getSessionId(), this.options.getMemoryId(), this.options.getBizParams()), new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestParameters(this.options.getHasThoughts(), stream != false && this.options.getIncrementalOutput() != false));
    }

    private ChatResponse toChatResponse(DashScopeAgentApi.DashScopeAgentResponse response) {
        DashScopeAgentApi.DashScopeAgentResponse.DashScopeAgentResponseOutput output = response.output();
        DashScopeAgentApi.DashScopeAgentResponse.DashScopeAgentResponseUsage usage = response.usage();
        String text = output.text();
        if (text == null) {
            text = "";
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(REQUEST_ID, response.requestId());
        metadata.put(USAGE, usage);
        metadata.put(OUTPUT, output);
        AssistantMessage assistantMessage = new AssistantMessage(text, metadata);
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(output.finishReason()).build();
        Generation generation = new Generation(assistantMessage, generationMetadata);
        return new ChatResponse(List.of(generation));
    }
}

