/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.audio;

import com.alibaba.cloud.ai.dashscope.api.DashScopeSpeechSynthesisApi;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeSpeechSynthesisOptions
implements SpeechSynthesisOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="voice")
    private String voice = null;
    @JsonProperty(value="request_text_type")
    private DashScopeSpeechSynthesisApi.RequestTextType requestTextType = DashScopeSpeechSynthesisApi.RequestTextType.PLAIN_TEXT;
    @JsonProperty(value="sample_rate")
    private Integer sampleRate = 48000;
    @JsonProperty(value="volume")
    private Integer volume = 50;
    @JsonProperty(value="speed")
    private Double speed = 1.0;
    @JsonProperty(value="pitch")
    private Double pitch = 1.0;
    @JsonProperty(value="enable_word_timestamp")
    private Boolean enableWordTimestamp = false;
    @JsonProperty(value="enable_phoneme_timestamp")
    private Boolean enablePhonemeTimestamp = false;
    @JsonProperty(value="response_format")
    private DashScopeSpeechSynthesisApi.ResponseFormat responseFormat = DashScopeSpeechSynthesisApi.ResponseFormat.MP3;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double pitch) {
        this.pitch = pitch;
    }

    Boolean getEnableWordTimestamp() {
        return this.enableWordTimestamp;
    }

    public Boolean isEnableWordTimestamp() {
        return this.enableWordTimestamp != null && this.enableWordTimestamp != false;
    }

    public void setEnableWordTimestamp(Boolean enableWordTimestamp) {
        this.enableWordTimestamp = enableWordTimestamp;
    }

    Boolean getEnablePhonemeTimestamp() {
        return this.enablePhonemeTimestamp;
    }

    public Boolean isEnablePhonemeTimestamp() {
        return this.enablePhonemeTimestamp != null && this.enablePhonemeTimestamp != false;
    }

    public void setEnablePhonemeTimestamp(Boolean enablePhonemeTimestamp) {
        this.enablePhonemeTimestamp = enablePhonemeTimestamp;
    }

    DashScopeSpeechSynthesisApi.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    void setResponseFormat(DashScopeSpeechSynthesisApi.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public DashScopeSpeechSynthesisApi.RequestTextType getRequestTextType() {
        return this.requestTextType;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public static class Builder {
        private final DashScopeSpeechSynthesisOptions options = new DashScopeSpeechSynthesisOptions();

        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        public Builder withText(String text) {
            this.options.text = text;
            return this;
        }

        public Builder withVoice(String voice) {
            this.options.voice = voice;
            return this;
        }

        public Builder withRequestText(DashScopeSpeechSynthesisApi.RequestTextType requestTextType) {
            this.options.requestTextType = requestTextType;
            return this;
        }

        public Builder withSampleRate(Integer sampleRate) {
            this.options.sampleRate = sampleRate;
            return this;
        }

        public Builder withVolume(Integer volume) {
            this.options.volume = volume;
            return this;
        }

        public Builder withSpeed(Double speed) {
            this.options.speed = speed;
            return this;
        }

        public Builder withResponseFormat(DashScopeSpeechSynthesisApi.ResponseFormat format) {
            this.options.responseFormat = format;
            return this;
        }

        public Builder withPitch(Double pitch) {
            this.options.pitch = pitch;
            return this;
        }

        public Builder withEnableWordTimestamp(Boolean enableWordTimestamp) {
            this.options.enableWordTimestamp = enableWordTimestamp;
            return this;
        }

        public Builder withEnablePhonemeTimestamp(Boolean enablePhonemeTimestamp) {
            this.options.enablePhonemeTimestamp = enablePhonemeTimestamp;
            return this;
        }

        public DashScopeSpeechSynthesisOptions build() {
            return this.options;
        }
    }
}

