/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.chat.MessageFormat;
import com.alibaba.cloud.ai.dashscope.chat.observation.DashScopeChatModelObservationConvention;
import com.alibaba.cloud.ai.dashscope.common.DashScopeApiConstants;
import com.alibaba.cloud.ai.dashscope.metadata.DashScopeAiUsage;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DashScopeChatModel
extends AbstractToolCallSupport
implements ChatModel {
    public static final String MESSAGE_FORMAT = "messageFormat";
    private static final Logger logger = LoggerFactory.getLogger(DashScopeChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DashScopeChatModelObservationConvention();
    private final DashScopeApi dashscopeApi;
    public final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private DashScopeChatOptions defaultOptions;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public DashScopeChatModel(DashScopeApi dashscopeApi) {
        this(dashscopeApi, DashScopeChatOptions.builder().withModel(DashScopeApi.DEFAULT_CHAT_MODEL).withTemperature(0.7).build());
    }

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions options) {
        this(dashscopeApi, options, null, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions options, FunctionCallbackResolver functionCallbackResolver, RetryTemplate retryTemplate) {
        this(dashscopeApi, options, functionCallbackResolver, List.of(), retryTemplate);
    }

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate) {
        this(dashscopeApi, options, functionCallbackResolver, toolFunctionCallbacks, retryTemplate, ObservationRegistry.NOOP);
    }

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(functionCallbackResolver, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)dashscopeApi, (String)"DashScopeApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.isTrue((boolean)CollectionUtils.isEmpty(options.getFunctionCallbacks()), (String)"The default function callbacks must be set via the toolFunctionCallbacks constructor parameter");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.dashscopeApi = dashscopeApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).requestOptions((ChatOptions)(prompt.getOptions() != null ? prompt.getOptions() : this.defaultOptions)).build();
        ChatResponse chatResponse = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            DashScopeApi.ChatCompletionRequest request = this.createRequest(prompt, false);
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionEntity(request));
            DashScopeApi.ChatCompletion chatCompletion = (DashScopeApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<DashScopeApi.ChatCompletionOutput.Choice> choices = chatCompletion.output().choices();
            List<Generation> generations = choices.stream().map(choice -> {
                Map<String, Object> metadata = Map.of("id", chatCompletion.requestId(), "role", choice.message().role() != null ? choice.message().role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return DashScopeChatModel.buildGeneration(choice, metadata);
            }).toList();
            ChatResponse response = new ChatResponse(generations, this.from((DashScopeApi.ChatCompletion)completionEntity.getBody()));
            observationContext.setResponse((Object)response);
            return response;
        });
        if (this.isToolCall(chatResponse, Set.of(DashScopeApi.ChatCompletionFinishReason.TOOL_CALLS.name(), DashScopeApi.ChatCompletionFinishReason.STOP.name()))) {
            List toolCallConversation = this.handleToolCalls(prompt, chatResponse);
            return this.call(new Prompt(toolCallConversation, prompt.getOptions()));
        }
        return chatResponse;
    }

    public ChatOptions getDefaultOptions() {
        return DashScopeChatOptions.fromOptions(this.defaultOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            DashScopeApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).requestOptions((ChatOptions)(prompt.getOptions() != null ? prompt.getOptions() : this.defaultOptions)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String requestId = chatCompletion2.requestId();
                    List<Generation> generations = chatCompletion2.output().choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(requestId, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.requestId(), "role", roleMap.getOrDefault(requestId, ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return DashScopeChatModel.buildGeneration(choice, metadata);
                    }).toList();
                    if (chatCompletion2.usage() != null) {
                        return new ChatResponse(generations, this.from((DashScopeApi.ChatCompletion)chatCompletion2));
                    }
                    return new ChatResponse(generations);
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux flux = chatResponse.flatMap(response -> {
                if (this.isToolCall((ChatResponse)response, Set.of(DashScopeApi.ChatCompletionFinishReason.TOOL_CALLS.name(), DashScopeApi.ChatCompletionFinishReason.STOP.name()))) {
                    List toolCallConversation = this.handleToolCalls(prompt, (ChatResponse)response);
                    return this.stream(new Prompt(toolCallConversation, prompt.getOptions()));
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private static Generation buildGeneration(DashScopeApi.ChatCompletionOutput.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    private DashScopeApi.ChatCompletion chunkToChatCompletion(DashScopeApi.ChatCompletionChunk chunk) {
        return new DashScopeApi.ChatCompletion(chunk.requestId(), new DashScopeApi.ChatCompletionOutput(chunk.output().text(), chunk.output().choices()), chunk.usage());
    }

    private ChatResponseMetadata from(DashScopeApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"DashScopeAi ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.requestId()).usage((Usage)DashScopeAiUsage.from(result.usage())).model("").build();
    }

    DashScopeApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        HashSet<String> enabledToolsToUse = new HashSet<String>();
        DashScopeChatOptions options = DashScopeChatOptions.builder().build();
        if (prompt.getOptions() != null) {
            DashScopeChatOptions updatedRuntimeOptions = (DashScopeChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, DashScopeChatOptions.class);
            enabledToolsToUse.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
            options = (DashScopeChatOptions)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)options, DashScopeChatOptions.class);
        }
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            enabledToolsToUse.addAll(this.defaultOptions.getFunctions());
        }
        options = (DashScopeChatOptions)ModelOptionsUtils.merge((Object)options, (Object)this.defaultOptions, DashScopeChatOptions.class);
        if (!CollectionUtils.isEmpty(enabledToolsToUse)) {
            options.setTools(this.getFunctionTools(enabledToolsToUse));
        }
        List<DashScopeApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                UserMessage userMessage;
                Object content = message.getText();
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    content = this.convertMediaContent(userMessage);
                }
                return List.of(new DashScopeApi.ChatCompletionMessage(content, DashScopeApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<DashScopeApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        DashScopeApi.ChatCompletionMessage.ChatCompletionFunction function = new DashScopeApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new DashScopeApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new DashScopeApi.ChatCompletionMessage(assistantMessage.getContent(), DashScopeApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> {
                    Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id");
                    Assert.isTrue((response.name() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have a name");
                });
                return toolMessage.getResponses().stream().map(tr -> new DashScopeApi.ChatCompletionMessage(tr.responseData(), DashScopeApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + message.getMessageType());
        }).flatMap(Collection::stream).toList();
        boolean multiModel = options.getMultiModel();
        return new DashScopeApi.ChatCompletionRequest(options.getModel(), new DashScopeApi.ChatCompletionRequestInput(chatCompletionMessages), this.toDashScopeRequestParameter(options, stream), stream, multiModel);
    }

    private List<DashScopeApi.ChatCompletionMessage.MediaContent> convertMediaContent(UserMessage message) {
        MessageFormat format = MessageFormat.IMAGE;
        Object v = message.getMetadata().get(MESSAGE_FORMAT);
        if (v instanceof MessageFormat) {
            MessageFormat messageFormat;
            format = messageFormat = (MessageFormat)((Object)v);
        }
        ArrayList<DashScopeApi.ChatCompletionMessage.MediaContent> contentList = new ArrayList<DashScopeApi.ChatCompletionMessage.MediaContent>();
        if (format == MessageFormat.VIDEO) {
            mediaContent = new DashScopeApi.ChatCompletionMessage.MediaContent(message.getContent());
            contentList.add(mediaContent);
            List<String> mediaList = message.getMedia().stream().map(media -> this.fromMediaData(media.getMimeType(), media.getData())).toList();
            contentList.add(new DashScopeApi.ChatCompletionMessage.MediaContent("video", null, null, mediaList));
        } else {
            mediaContent = new DashScopeApi.ChatCompletionMessage.MediaContent(message.getContent());
            contentList.add(mediaContent);
            contentList.addAll(message.getMedia().stream().map(media -> new DashScopeApi.ChatCompletionMessage.MediaContent("image", null, this.fromMediaData(media.getMimeType(), media.getData()), null)).toList());
        }
        return contentList;
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    private List<DashScopeApi.FunctionTool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            DashScopeApi.FunctionTool.Function function = new DashScopeApi.FunctionTool.Function(functionCallback.getDescription(), functionCallback.getName(), functionCallback.getInputTypeSchema());
            return new DashScopeApi.FunctionTool(function);
        }).toList();
    }

    private DashScopeApi.ChatCompletionRequestParameter toDashScopeRequestParameter(DashScopeChatOptions options, boolean stream) {
        if (options == null) {
            return new DashScopeApi.ChatCompletionRequestParameter();
        }
        Boolean incrementalOutput = stream && options.getIncrementalOutput() != false;
        return new DashScopeApi.ChatCompletionRequestParameter("message", options.getSeed(), options.getMaxTokens(), options.getTopP(), options.getTopK(), options.getRepetitionPenalty(), options.getPresencePenalty(), options.getTemperature(), options.getStop(), options.getEnableSearch(), options.getResponseFormat(), incrementalOutput, options.getTools(), options.getToolChoice(), stream, options.getVlHighResolutionImages());
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

