/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeResponseFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeChatOptions
implements FunctionCallingOptions,
ChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonIgnore
    private Boolean stream;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="stop")
    private List<Object> stop;
    @JsonProperty(value="enable_search")
    private Boolean enableSearch = false;
    @JsonProperty(value="response_format")
    private DashScopeResponseFormat responseFormat;
    @JsonProperty(value="incremental_output")
    private Boolean incrementalOutput = true;
    @JsonProperty(value="repetition_penalty")
    private Double repetitionPenalty;
    @JsonProperty(value="tools")
    private List<DashScopeApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonProperty(value="vl_high_resolution_images")
    private Boolean vlHighResolutionImages;
    @NestedConfigurationProperty
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @NestedConfigurationProperty
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonProperty(value="multi_model")
    private Boolean multiModel = false;
    @NestedConfigurationProperty
    @JsonIgnore
    private Map<String, Object> toolContext;

    public String getModel() {
        return this.model;
    }

    public Double getFrequencyPenalty() {
        return null;
    }

    public Integer getMaxTokens() {
        return null;
    }

    public Double getPresencePenalty() {
        return null;
    }

    public List<String> getStopSequences() {
        return null;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatOptions copy() {
        return DashScopeChatOptions.fromOptions(this);
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public List<Object> getStop() {
        return this.stop;
    }

    public void setStop(List<Object> stop) {
        this.stop = stop;
    }

    public DashScopeResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(DashScopeResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public List<DashScopeApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<DashScopeApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public Boolean getVlHighResolutionImages() {
        return this.vlHighResolutionImages;
    }

    public void setVlHighResolutionImages(Boolean vlHighResolutionImages) {
        this.vlHighResolutionImages = vlHighResolutionImages;
    }

    public Boolean getMultiModel() {
        return this.multiModel;
    }

    public void setMultiModel(Boolean multiModel) {
        this.multiModel = multiModel;
    }

    public static DashscopeChatOptionsBuilder builder() {
        return new DashscopeChatOptionsBuilder();
    }

    public static DashScopeChatOptions fromOptions(DashScopeChatOptions fromOptions) {
        return DashScopeChatOptions.builder().withModel(fromOptions.getModel()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).withSeed(fromOptions.getSeed()).withStop(fromOptions.getStop()).withResponseFormat(fromOptions.getResponseFormat()).withStream(fromOptions.getStream()).withEnableSearch(fromOptions.enableSearch).withIncrementalOutput(fromOptions.getIncrementalOutput()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).withRepetitionPenalty(fromOptions.getRepetitionPenalty()).withTools(fromOptions.getTools()).withToolContext(fromOptions.getToolContext()).withMultiModel(fromOptions.getMultiModel()).withVlHighResolutionImages(fromOptions.getVlHighResolutionImages()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashScopeChatOptions that = (DashScopeChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.stream, that.stream) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.seed, that.seed) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.stop, that.stop) && Objects.equals(this.enableSearch, that.enableSearch) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.incrementalOutput, that.incrementalOutput) && Objects.equals(this.repetitionPenalty, that.repetitionPenalty) && Objects.equals(this.tools, that.tools) && Objects.equals(this.toolChoice, that.toolChoice) && Objects.equals(this.vlHighResolutionImages, that.vlHighResolutionImages) && Objects.equals(this.functionCallbacks, that.functionCallbacks) && Objects.equals(this.functions, that.functions) && Objects.equals(this.multiModel, that.multiModel) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.stream, this.temperature, this.seed, this.topP, this.topK, this.stop, this.enableSearch, this.responseFormat, this.incrementalOutput, this.repetitionPenalty, this.tools, this.toolChoice, this.vlHighResolutionImages, this.functionCallbacks, this.functions, this.multiModel, this.toolContext);
    }

    public String toString() {
        return "DashScopeChatOptions: " + ModelOptionsUtils.toJsonString((Object)this);
    }

    public static class DashscopeChatOptionsBuilder {
        private DashScopeChatOptions options = new DashScopeChatOptions();

        public DashscopeChatOptionsBuilder withModel(String model) {
            this.options.model = model;
            return this;
        }

        public DashscopeChatOptionsBuilder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public DashscopeChatOptionsBuilder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public DashscopeChatOptionsBuilder withTopK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public DashscopeChatOptionsBuilder withStop(List<Object> stop) {
            this.options.stop = stop;
            return this;
        }

        public DashscopeChatOptionsBuilder withResponseFormat(DashScopeResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public DashscopeChatOptionsBuilder withEnableSearch(Boolean enableSearch) {
            this.options.enableSearch = enableSearch;
            return this;
        }

        public DashscopeChatOptionsBuilder withRepetitionPenalty(Double repetitionPenalty) {
            this.options.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public DashscopeChatOptionsBuilder withTools(List<DashScopeApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public DashscopeChatOptionsBuilder withStream(Boolean stream) {
            this.options.stream = stream;
            return this;
        }

        public DashscopeChatOptionsBuilder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public DashscopeChatOptionsBuilder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public DashscopeChatOptionsBuilder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public DashscopeChatOptionsBuilder withSeed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public DashscopeChatOptionsBuilder withIncrementalOutput(Boolean incrementalOutput) {
            this.options.incrementalOutput = incrementalOutput;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public DashscopeChatOptionsBuilder withVlHighResolutionImages(Boolean vlHighResolutionImages) {
            this.options.vlHighResolutionImages = vlHighResolutionImages;
            return this;
        }

        public DashscopeChatOptionsBuilder withMultiModel(Boolean multiModel) {
            this.options.multiModel = multiModel;
            return this;
        }

        public DashScopeChatOptions build() {
            return this.options;
        }
    }
}

