/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat.observation;

import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.fastjson.JSON;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.util.CollectionUtils;

public class DashScopeChatModelObservationConvention
extends DefaultChatModelObservationConvention {
    public static final String DEFAULT_NAME = "gen_ai.client.operation";
    private static final String ILLEGAL_STOP_CONTENT = "<illegal_stop_content>";

    public String getName() {
        return DEFAULT_NAME;
    }

    protected KeyValues requestStopSequences(KeyValues keyValues, ChatModelObservationContext context) {
        if (context.getRequestOptions() instanceof DashScopeChatOptions) {
            String stopSequences;
            List<Object> stop = ((DashScopeChatOptions)context.getRequestOptions()).getStop();
            if (CollectionUtils.isEmpty(stop)) {
                return keyValues;
            }
            KeyValue.of((KeyName)ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_STOP_SEQUENCES, stop, Objects::nonNull);
            try {
                stopSequences = JSON.toJSONString(stop);
            }
            catch (Exception e) {
                stopSequences = ILLEGAL_STOP_CONTENT;
            }
            return keyValues.and(ChatModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_STOP_SEQUENCES.asString(), stopSequences);
        }
        return super.requestStopSequences(keyValues, context);
    }
}

