/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.rag.AnalyticdbConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.gpdb20160503.Client;
import com.aliyun.gpdb20160503.models.CreateCollectionRequest;
import com.aliyun.gpdb20160503.models.CreateNamespaceRequest;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataRequest;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataResponse;
import com.aliyun.gpdb20160503.models.DescribeCollectionRequest;
import com.aliyun.gpdb20160503.models.DescribeNamespaceRequest;
import com.aliyun.gpdb20160503.models.InitVectorDatabaseRequest;
import com.aliyun.gpdb20160503.models.InitVectorDatabaseResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataRequest;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponseBody;
import com.aliyun.gpdb20160503.models.UpsertCollectionDataRequest;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;

public class AnalyticdbVector
implements VectorStore {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticdbVector.class);
    private final String collectionName;
    private AnalyticdbConfig config;
    private Client client;
    private final EmbeddingModel embeddingModel;

    public AnalyticdbVector(String collectionName, AnalyticdbConfig config, EmbeddingModel embeddingModel) throws Exception {
        this.collectionName = collectionName.toLowerCase();
        this.config = config;
        Config clientConfig = Config.build(this.config.toAnalyticdbClientParams());
        this.client = new Client(clientConfig);
        this.embeddingModel = embeddingModel;
        this.initialize();
        logger.debug("created AnalyticdbVector client success");
    }

    private void initialize() throws Exception {
        this.initializeVectorDataBase();
        this.createNameSpaceIfNotExists();
        this.createCollectionIfNotExists(this.config.getEmbeddingDimension());
    }

    private void initializeVectorDataBase() throws Exception {
        InitVectorDatabaseRequest request = new InitVectorDatabaseRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword());
        InitVectorDatabaseResponse initVectorDatabaseResponse = this.client.initVectorDatabase(request);
        logger.debug("successfully initialize vector database, response body:{}", (Object)initVectorDatabaseResponse.getBody());
    }

    private void createNameSpaceIfNotExists() throws Exception {
        try {
            DescribeNamespaceRequest request = new DescribeNamespaceRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword());
            this.client.describeNamespace(request);
        }
        catch (TeaException e) {
            if (Objects.equals(e.getStatusCode(), 404)) {
                CreateNamespaceRequest request = new CreateNamespaceRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword()).setNamespacePassword(this.config.getNamespacePassword());
                this.client.createNamespace(request);
            }
            throw new Exception("failed to create namespace:{}", e);
        }
    }

    private void createCollectionIfNotExists(Long embeddingDimension) throws Exception {
        try {
            DescribeCollectionRequest describeRequest = new DescribeCollectionRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName);
            this.client.describeCollection(describeRequest);
            logger.debug("collection" + this.collectionName + "already exists");
        }
        catch (TeaException e) {
            if (Objects.equals(e.getStatusCode(), 404)) {
                String metadata = JSON.toJSONString((Object)new JSONObject().fluentPut("refDocId", (Object)"text").fluentPut("content", (Object)"text").fluentPut("metadata", (Object)"jsonb"));
                String fullTextRetrievalFields = "content";
                CreateCollectionRequest createRequest = new CreateCollectionRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword()).setNamespace(this.config.getNamespace()).setCollection(this.collectionName).setDimension(embeddingDimension).setMetrics(this.config.getMetrics()).setMetadata(metadata).setFullTextRetrievalFields(fullTextRetrievalFields);
                this.client.createCollection(createRequest);
                logger.debug("collection" + this.collectionName + "created");
            }
            throw new RuntimeException("Failed to create collection " + this.collectionName + ": " + e.getMessage());
        }
    }

    public void add(List<Document> documents) {
        ArrayList<UpsertCollectionDataRequest.UpsertCollectionDataRequestRows> rows = new ArrayList<UpsertCollectionDataRequest.UpsertCollectionDataRequestRows>(10);
        for (Document doc : documents) {
            logger.info("Calling EmbeddingModel for document id = {}", (Object)doc.getId());
            float[] floatEmbeddings = this.embeddingModel.embed(doc);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("refDocId", (String)doc.getMetadata().get("docId"));
            metadata.put("content", doc.getText());
            metadata.put("metadata", JSON.toJSONString((Object)doc.getMetadata()));
            List<Double> embedding = IntStream.range(0, floatEmbeddings.length).mapToObj(i -> floatEmbeddings[i]).toList();
            rows.add(new UpsertCollectionDataRequest.UpsertCollectionDataRequestRows().setVector(embedding).setMetadata(metadata));
        }
        UpsertCollectionDataRequest request = new UpsertCollectionDataRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setRows(rows);
        try {
            this.client.upsertCollectionData(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add collection data by IDs: " + e.getMessage(), e);
        }
    }

    public Optional<Boolean> delete(List<String> ids) {
        if (ids.isEmpty()) {
            return Optional.of(false);
        }
        String idsStr = ids.stream().map(id -> "'" + id + "'").collect(Collectors.joining(", ", "(", ")"));
        DeleteCollectionDataRequest request = new DeleteCollectionDataRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setCollectionData(null).setCollectionDataFilter("refDocId IN " + idsStr);
        try {
            DeleteCollectionDataResponse deleteCollectionDataResponse = this.client.deleteCollectionData(request);
            return deleteCollectionDataResponse.statusCode.equals(200) ? Optional.of(true) : Optional.of(false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete collection data by IDs: " + e.getMessage(), e);
        }
    }

    public List<Document> similaritySearch(String query) {
        return this.similaritySearch(SearchRequest.builder().query(query).build());
    }

    public List<Document> similaritySearch(SearchRequest searchRequest) {
        double scoreThreshold = searchRequest.getSimilarityThreshold();
        boolean includeValues = searchRequest.hasFilterExpression();
        int topK = searchRequest.getTopK();
        QueryCollectionDataRequest request = new QueryCollectionDataRequest().setDBInstanceId(this.config.getDBInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setIncludeValues(Boolean.valueOf(includeValues)).setMetrics(this.config.getMetrics()).setVector(null).setContent(searchRequest.getQuery()).setTopK(Long.valueOf(topK)).setFilter(null);
        try {
            QueryCollectionDataResponse response = this.client.queryCollectionData(request);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (QueryCollectionDataResponseBody.QueryCollectionDataResponseBodyMatchesMatch match : response.getBody().getMatches().getMatch()) {
                if (match.getScore() == null || !(match.getScore() > scoreThreshold)) continue;
                Map metadata = match.getMetadata();
                String pageContent = (String)metadata.get("content");
                Map metadataJson = (Map)JSONObject.parseObject((String)((String)metadata.get("metadata")), HashMap.class);
                Document doc = new Document(pageContent, metadataJson);
                documents.add(doc);
            }
            return documents;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to search by full text: " + e.getMessage(), e);
        }
    }
}

