/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.document;

import com.alibaba.cloud.ai.document.DocumentParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.springframework.ai.document.Document;
import org.springframework.util.Assert;

public class TextDocumentParser
implements DocumentParser {
    private final Charset charset;

    public TextDocumentParser() {
        this(StandardCharsets.UTF_8);
    }

    public TextDocumentParser(Charset charset) {
        Assert.notNull((Object)charset, (String)"charset");
        this.charset = charset;
    }

    @Override
    public List<Document> parse(InputStream inputStream) {
        try {
            String text = new String(inputStream.readAllBytes(), this.charset);
            if (text.isBlank()) {
                throw new Exception();
            }
            return Collections.singletonList(new Document(text));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

