/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.ApiUtils;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAiStreamFunctionCallingHelper;
import com.alibaba.cloud.ai.dashscope.api.DashScopeResponseFormat;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.common.ErrorCodeEnum;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentRetrieverOptions;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentTransformerOptions;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeStoreOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DashScopeApi {
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    public static final String DEFAULT_CHAT_MODEL = ChatModel.QWEN_PLUS.getModel();
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.EMBEDDING_V2.getValue();
    public static final String DEFAULT_EMBEDDING_TEXT_TYPE = EmbeddingTextType.DOCUMENT.getValue();
    public static final String DEFAULT_PARSER_NAME = "DASHSCOPE_DOCMIND";
    private final RestClient restClient;
    private final WebClient webClient;

    public DashScopeApi(String apiKey) {
        this("https://dashscope.aliyuncs.com", apiKey, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeApi(String apiKey, String workSpaceId) {
        this("https://dashscope.aliyuncs.com", apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeApi(String baseUrl, String apiKey, String workSpaceId) {
        this(baseUrl, apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey)).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey)).build();
    }

    public DashScopeApi(String baseUrl, String apiKey, String workSpaceId, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, workSpaceId)).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, workSpaceId)).build();
    }

    public ResponseEntity<EmbeddingList> embeddings(EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull((Object)embeddingRequest.input(), (String)"The input can not be null.");
        Assert.isTrue((!CollectionUtils.isEmpty(embeddingRequest.input().texts()) ? 1 : 0) != 0, (String)"The input texts can not be empty.");
        Assert.isTrue((embeddingRequest.input().texts().size() <= 25 ? 1 : 0) != 0, (String)"The input texts limit 25.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/services/embeddings/text-embedding/text-embedding", new Object[0])).body((Object)embeddingRequest).retrieve().toEntity(EmbeddingList.class);
    }

    public String upload(File file, UploadRequest request) {
        ResponseEntity<UploadLeaseResponse> responseEntity = this.uploadLease(request);
        UploadLeaseResponse uploadLeaseResponse = (UploadLeaseResponse)responseEntity.getBody();
        if (uploadLeaseResponse == null) {
            throw new DashScopeException(ErrorCodeEnum.READER_APPLY_LEASE_ERROR);
        }
        if (!"SUCCESS".equalsIgnoreCase(uploadLeaseResponse.code())) {
            throw new DashScopeException("ApplyLease Failed,code:%s,message:%s".formatted(uploadLeaseResponse.code(), uploadLeaseResponse.message()));
        }
        this.uploadFile(file, uploadLeaseResponse);
        return this.addFile(uploadLeaseResponse.data.leaseId(), request);
    }

    public ResponseEntity<CommonResponse<QueryFileResponseData>> queryFileInfo(String categoryId, UploadRequest.QueryFileRequest request) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{category}/file/{fileId}/query", new Object[]{categoryId, request.fileId})).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<CommonResponse<QueryFileResponseData>>(){});
    }

    public String getFileParseResult(String categoryId, UploadRequest.QueryFileRequest request) {
        ResponseEntity fileParseResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{categoryId}/file/{fileId}/download_lease", new Object[]{categoryId, request.fileId()})).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<CommonResponse<QueryFileParseResultData>>(){});
        if (fileParseResponse == null || fileParseResponse.getBody() == null) {
            throw new DashScopeException("GetDocumentParseResultError");
        }
        CommonResponse commonResponse = (CommonResponse)fileParseResponse.getBody();
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        for (String key : ((QueryFileParseResultData)commonResponse.data).param.headers.keySet()) {
            headers.set(key, ((QueryFileParseResultData)commonResponse.data).param.headers.get(key));
        }
        try {
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(new URI(((QueryFileParseResultData)commonResponse.data).param.url), HttpMethod.GET, requestEntity, String.class);
            return (String)response.getBody();
        }
        catch (Exception ex) {
            throw new DashScopeException("GetDocumentParseResultError");
        }
    }

    private String addFile(String leaseId, UploadRequest request) {
        try {
            UploadRequest.AddFileRequest addFileRequest = new UploadRequest.AddFileRequest(leaseId, DEFAULT_PARSER_NAME);
            ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{categoryId}/add_file", new Object[]{request.categoryId})).body((Object)addFileRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<CommonResponse<AddFileResponseData>>(){});
            CommonResponse addFileResponse = (CommonResponse)response.getBody();
            if (addFileResponse == null || !"SUCCESS".equals(addFileResponse.code.toUpperCase())) {
                throw new DashScopeException(ErrorCodeEnum.READER_ADD_FILE_ERROR);
            }
            AddFileResponseData addFileResult = (AddFileResponseData)addFileResponse.data;
            return addFileResult.fileId();
        }
        catch (Exception ex) {
            throw new DashScopeException(ErrorCodeEnum.READER_ADD_FILE_ERROR);
        }
    }

    private void uploadFile(final File file, UploadLeaseResponse uploadLeaseResponse) {
        try {
            UploadLeaseResponse.UploadLeaseParamData uploadParam = uploadLeaseResponse.data.param;
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            String contentType = uploadParam.header.remove("Content-Type");
            headers.setContentType(MediaType.parseMediaType((String)contentType));
            for (String key : uploadParam.header.keySet()) {
                headers.set(key, uploadParam.header.get(key));
            }
            InputStreamResource resource = new InputStreamResource(new FileInputStream(file)){

                public long contentLength() {
                    return file.length();
                }

                public String getFilename() {
                    return file.getName();
                }
            };
            HttpEntity requestEntity = new HttpEntity((Object)resource, (MultiValueMap)headers);
            restTemplate.exchange(new URI(uploadParam.url), HttpMethod.PUT, requestEntity, Void.class);
        }
        catch (Exception ex) {
            throw new DashScopeException("Upload File Failed", ex);
        }
    }

    private ResponseEntity<UploadLeaseResponse> uploadLease(UploadRequest request) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{categoryId}/upload_lease", new Object[]{request.categoryId})).body((Object)request).retrieve().toEntity(UploadLeaseResponse.class);
    }

    public ResponseEntity<DocumentSplitResponse> documentSplit(Document document, DashScopeDocumentTransformerOptions options) {
        DocumentSplitRequest request = new DocumentSplitRequest(document.getText(), options.getChunkSize(), options.getOverlapSize(), options.getFileType(), options.getLanguage(), options.getSeparator());
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/component/configed_transformations/spliter", new Object[0])).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<DocumentSplitResponse>(){});
    }

    public String getPipelineIdByName(String pipelineName) {
        ResponseEntity startPipelineResponse = this.restClient.get().uri("/api/v1/indices/pipeline_simple?pipeline_name={pipelineName}", new Object[]{pipelineName}).retrieve().toEntity(QueryPipelineResponse.class);
        if (startPipelineResponse == null || startPipelineResponse.getBody() == null || ((QueryPipelineResponse)startPipelineResponse.getBody()).pipelineId() == null) {
            return null;
        }
        return ((QueryPipelineResponse)startPipelineResponse.getBody()).pipelineId;
    }

    public void upsertPipeline(List<Document> documents, DashScopeStoreOptions storeOptions) {
        String embeddingModelName = storeOptions.getEmbeddingOptions() == null ? EmbeddingModel.EMBEDDING_V2.getValue() : storeOptions.getEmbeddingOptions().getModel();
        UpsertPipelineRequest.EmbeddingConfiguredTransformations embeddingConfig = new UpsertPipelineRequest.EmbeddingConfiguredTransformations("DASHSCOPE_EMBEDDING", new UpsertPipelineRequest.EmbeddingConfiguredTransformations.EmbeddingComponent(embeddingModelName));
        DashScopeDocumentTransformerOptions transformerOptions = storeOptions.getTransformerOptions();
        if (transformerOptions == null) {
            transformerOptions = new DashScopeDocumentTransformerOptions();
        }
        UpsertPipelineRequest.ParserConfiguredTransformations parserConfig = new UpsertPipelineRequest.ParserConfiguredTransformations("DASHSCOPE_JSON_NODE_PARSER", new UpsertPipelineRequest.ParserConfiguredTransformations.ParserComponent(transformerOptions.getChunkSize(), transformerOptions.getOverlapSize(), "idp", transformerOptions.getSeparator(), transformerOptions.getLanguage()));
        DashScopeDocumentRetrieverOptions retrieverOptions = storeOptions.getRetrieverOptions();
        if (retrieverOptions == null) {
            retrieverOptions = new DashScopeDocumentRetrieverOptions();
        }
        UpsertPipelineRequest.RetrieverConfiguredTransformations retrieverConfig = new UpsertPipelineRequest.RetrieverConfiguredTransformations("DASHSCOPE_RETRIEVER", new UpsertPipelineRequest.RetrieverConfiguredTransformations.RetrieverComponent(retrieverOptions.isEnableRewrite(), Arrays.asList(new UpsertPipelineRequest.RetrieverConfiguredTransformations.CommonModelComponent(retrieverOptions.getRewriteModelName())), retrieverOptions.getSparseSimilarityTopK(), retrieverOptions.getDenseSimilarityTopK(), retrieverOptions.isEnableReranking(), Arrays.asList(new UpsertPipelineRequest.RetrieverConfiguredTransformations.CommonModelComponent(retrieverOptions.getRerankModelName())), retrieverOptions.getRerankMinScore(), retrieverOptions.getRerankTopN()));
        List<String> documentIdList = documents.stream().map(Document::getId).filter(Objects::nonNull).collect(Collectors.toList());
        UpsertPipelineRequest upsertPipelineRequest = new UpsertPipelineRequest(storeOptions.getIndexName(), "MANAGED_SHARED", null, "unstructured", "recommend", Arrays.asList(embeddingConfig, parserConfig, retrieverConfig), Arrays.asList(new UpsertPipelineRequest.DataSourcesConfig("DATA_CENTER_FILE", new UpsertPipelineRequest.DataSourcesConfig.DataSourcesComponent(documentIdList))), Arrays.asList(new UpsertPipelineRequest.DataSinksConfig("ES", null)));
        ResponseEntity upsertPipelineResponse = ((RestClient.RequestBodySpec)this.restClient.put().uri("/api/v1/indices/pipeline", new Object[0])).body((Object)upsertPipelineRequest).retrieve().toEntity(UpsertPipelineResponse.class);
        if (upsertPipelineResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((UpsertPipelineResponse)upsertPipelineResponse.getBody()).status)) {
            throw new DashScopeException(ErrorCodeEnum.CREATE_INDEX_ERROR);
        }
        String pipelineId = ((UpsertPipelineResponse)upsertPipelineResponse.getBody()).id;
        ResponseEntity startPipelineResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/managed_ingest", new Object[]{pipelineId})).body((Object)upsertPipelineRequest).retrieve().toEntity(StartPipelineResponse.class);
        if (startPipelineResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((StartPipelineResponse)startPipelineResponse.getBody()).code) || ((StartPipelineResponse)startPipelineResponse.getBody()).ingestionId == null) {
            throw new DashScopeException(ErrorCodeEnum.INDEX_ADD_DOCUMENT_ERROR);
        }
    }

    public boolean deletePipelineDocument(String pipelineId, List<String> idList) {
        DelePipelineDocumentRequest request = new DelePipelineDocumentRequest(Arrays.asList(new DelePipelineDocumentRequest.DelePipelineDocumentDataSource("DATA_CENTER_FILE", Arrays.asList(new DelePipelineDocumentRequest.DelePipelineDocumentDataSourceComponent(idList)))));
        ResponseEntity deleDocumentResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/delete", new Object[]{pipelineId})).body((Object)request).retrieve().toEntity(DelePipelineDocumentResponse.class);
        return deleDocumentResponse != null && deleDocumentResponse.getBody() != null && "SUCCESS".equalsIgnoreCase(((DelePipelineDocumentResponse)deleDocumentResponse.getBody()).code);
    }

    public List<Document> retriever(String pipelineId, String query, DashScopeDocumentRetrieverOptions searchOption) {
        DocumentRetrieveRequest request = new DocumentRetrieveRequest(query, searchOption.getDenseSimilarityTopK(), searchOption.getDenseSimilarityTopK(), searchOption.isEnableRewrite(), Arrays.asList(new DocumentRetrieveRequest.DocumentRetrieveModelConfig(searchOption.getRewriteModelName(), "DashScopeTextRewrite")), searchOption.isEnableReranking(), Arrays.asList(new DocumentRetrieveRequest.DocumentRetrieveModelConfig(searchOption.getRerankModelName(), null)), searchOption.getRerankMinScore(), searchOption.getRerankTopN());
        ResponseEntity deleDocumentResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/retrieve", new Object[]{pipelineId})).body((Object)request).retrieve().toEntity(DocumentRetrieveResponse.class);
        if (deleDocumentResponse == null || deleDocumentResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((DocumentRetrieveResponse)deleDocumentResponse.getBody()).code)) {
            throw new DashScopeException(ErrorCodeEnum.RETRIEVER_DOCUMENT_ERROR);
        }
        List<DocumentRetrieveResponse.DocumentRetrieveResponseNode> nodeList = ((DocumentRetrieveResponse)deleDocumentResponse.getBody()).nodes;
        if (nodeList == null || nodeList.isEmpty()) {
            return new ArrayList<Document>();
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        nodeList.forEach(e -> {
            DocumentRetrieveResponse.DocumentRetrieveResponseNodeData nodeData = e.node;
            Document toDocument = new Document(nodeData.id, nodeData.text, nodeData.metadata);
            documents.add(toDocument);
        });
        return documents;
    }

    public static String getTextContent(List<ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        String uri = "/api/v1/services/aigc/text-generation/generation";
        if (chatRequest.multiModel().booleanValue()) {
            uri = "/api/v1/services/aigc/multimodal-generation/generation";
        }
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        boolean incrementalOutput = chatRequest.parameters() != null && chatRequest.parameters().incrementalOutput != null && chatRequest.parameters().incrementalOutput != false;
        DashScopeAiStreamFunctionCallingHelper chunkMerger = new DashScopeAiStreamFunctionCallingHelper(incrementalOutput);
        String uri = "/api/v1/services/aigc/text-generation/generation";
        if (chatRequest.multiModel().booleanValue()) {
            uri = "/api/v1/services/aigc/multimodal-generation/generation";
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(uri, new Object[0])).header("X-DashScope-SSE", new String[]{"enable"})).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null), chunkMerger::merge);
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public ResponseEntity<RerankResponse> rerankEntity(RerankRequest rerankRequest) {
        Assert.notNull((Object)rerankRequest, (String)"The request body can not be null.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/services/rerank/text-rerank/text-rerank", new Object[0])).body((Object)rerankRequest).retrieve().toEntity(RerankResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") EmbeddingRequestInput input, @JsonProperty(value="parameters") EmbeddingRequestInputParameters parameters) {
        public EmbeddingRequest(String text) {
            this(DEFAULT_EMBEDDING_MODEL, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        public EmbeddingRequest(String text, String model) {
            this(model, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        public EmbeddingRequest(String text, String model, String textType) {
            this(model, new EmbeddingRequestInput(List.of(text)), new EmbeddingRequestInputParameters(textType));
        }

        public EmbeddingRequest(List<String> texts) {
            this(DEFAULT_EMBEDDING_MODEL, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        public EmbeddingRequest(List<String> texts, String model) {
            this(model, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(DEFAULT_EMBEDDING_TEXT_TYPE));
        }

        public EmbeddingRequest(List<String> texts, String model, String textType) {
            this(model, new EmbeddingRequestInput(texts), new EmbeddingRequestInputParameters(textType));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequestInput(@JsonProperty(value="texts") List<String> texts) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingList(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="output") Embeddings output, @JsonProperty(value="usage") EmbeddingUsage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadRequest(@JsonProperty(value="category_id") String categoryId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="size_bytes") long fileLength, @JsonProperty(value="content_md5") String fileMD5) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record QueryFileRequest(@JsonProperty(value="file_id") String fileId) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record AddFileRequest(@JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="parser") String parser) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadLeaseResponse(@JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="data") UploadLeaseResponseData data) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record UploadLeaseResponseData(@JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="type") String type, @JsonProperty(value="param") UploadLeaseParamData param) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record UploadLeaseParamData(@JsonProperty(value="url") String url, @JsonProperty(value="method") String method, @JsonProperty(value="headers") Map<String, String> header) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CommonResponse<T>(@JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="data") T data) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryFileParseResultData(@JsonProperty(value="file_id") String fileId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="lease_id") String leaseId, @JsonProperty(value="type") String type, @JsonProperty(value="param") DownloadFileParam param) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DownloadFileParam(@JsonProperty(value="method") String method, @JsonProperty(value="url") String url, @JsonProperty(value="headers") Map<String, String> headers) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AddFileResponseData(@JsonProperty(value="file_id") String fileId, @JsonProperty(value="parser") String method) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentSplitRequest(@JsonProperty(value="text") String text, @JsonProperty(value="chunk_size") Integer chunkSize, @JsonProperty(value="overlap_size") Integer overlapSize, @JsonProperty(value="file_type") String fileType, @JsonProperty(value="language") String language, @JsonProperty(value="separator") String separator) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryPipelineResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="id") String pipelineId) {
    }

    public static enum EmbeddingModel {
        EMBEDDING_V1("text-embedding-v1"),
        EMBEDDING_V2("text-embedding-v2"),
        EMBEDDING_V3("text-embedding-v3");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UpsertPipelineRequest(@JsonProperty(value="name") String name, @JsonProperty(value="pipeline_type") String pipelineType, @JsonProperty(value="pipeline_description") String pipelineDescription, @JsonProperty(value="data_type") String dataType, @JsonProperty(value="config_model") String configModel, @JsonProperty(value="configured_transformations") List transformations, @JsonProperty(value="data_sources") List<DataSourcesConfig> dataSources, @JsonProperty(value="data_sinks") List<DataSinksConfig> dataSinks) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record RetrieverConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") RetrieverComponent component) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record RetrieverComponent(@JsonProperty(value="enable_rewrite") boolean enableRewrite, @JsonProperty(value="rewrite") List<CommonModelComponent> rewriteComponents, @JsonProperty(value="sparse_similarity_top_k") int sparseSimilarityTopK, @JsonProperty(value="dense_similarity_top_k") int denseSimilarityTopK, @JsonProperty(value="enable_reranking") boolean enableRerank, @JsonProperty(value="rerank") List<CommonModelComponent> rerankComponents, @JsonProperty(value="rerank_min_score") float rerankMinScore, @JsonProperty(value="rerank_top_n") int rerankTopN) {
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record CommonModelComponent(@JsonProperty(value="model_name") String modelName) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record EmbeddingConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") EmbeddingComponent component) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record EmbeddingComponent(@JsonProperty(value="model_name") String modelName) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ParserConfiguredTransformations(@JsonProperty(value="configurable_transformation_type") String transformationType, @JsonProperty(value="component") ParserComponent component) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record ParserComponent(@JsonProperty(value="chunk_size") Integer chunkSize, @JsonProperty(value="overlap_size") Integer overlapSize, @JsonProperty(value="input_type") String inputType, @JsonProperty(value="separator") String separator, @JsonProperty(value="language") String language) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DataSourcesConfig(@JsonProperty(value="source_type") String sourceType, @JsonProperty(value="component") DataSourcesComponent component) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DataSourcesComponent(@JsonProperty(value="doc_ids") List<String> docIds) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DataSinksConfig(@JsonProperty(value="sink_type") String sinkType, @JsonProperty(value="component") DataSinksComponent component) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DataSinksComponent() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UpsertPipelineResponse(@JsonProperty(value="id") String id, @JsonProperty(value="pipline_name") String pipline_name, @JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record StartPipelineResponse(@JsonProperty(value="ingestionId") String ingestionId, @JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="request_id") String requestId) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DelePipelineDocumentRequest(@JsonProperty(value="data_sources") List<DelePipelineDocumentDataSource> dataSources) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DelePipelineDocumentDataSourceComponent(@JsonProperty(value="doc_ids") List<String> docIds) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DelePipelineDocumentDataSource(@JsonProperty(value="source_type") String sourceType, @JsonProperty(value="component") List<DelePipelineDocumentDataSourceComponent> component) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DelePipelineDocumentResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentRetrieveRequest(@JsonProperty(value="query") String query, @JsonProperty(value="dense_similarity_top_k") int denseSimilarityTopK, @JsonProperty(value="sparse_similarity_top_k") int sparseSimilarityTopK, @JsonProperty(value="enable_rewrite") boolean enableRewrite, @JsonProperty(value="rewrite") List<DocumentRetrieveModelConfig> rewrite, @JsonProperty(value="enable_reranking") boolean enableReranking, @JsonProperty(value="rerank") List<DocumentRetrieveModelConfig> rerank, @JsonProperty(value="rerank_min_score") float rerankMinScore, @JsonProperty(value="rerank_top_n") int rerankTopN) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveModelConfig(@JsonProperty(value="model_name") String modelName, @JsonProperty(value="class_name") String className) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentRetrieveResponse(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message, @JsonProperty(value="code") String code, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="total") int total, @JsonProperty(value="nodes") List<DocumentRetrieveResponseNode> nodes) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNodeMetaData(@JsonProperty(value="parent") String text, @JsonProperty(value="image_url") List<String> images, @JsonProperty(value="title") String title, @JsonProperty(value="doc_id") String documentId, @JsonProperty(value="doc_name") String docName, @JsonProperty(value="hier_title") String hierTitle) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNodeData(@JsonProperty(value="id_") String id, @JsonProperty(value="text") String text, @JsonProperty(value="metadata") Map<String, Object> metadata) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentRetrieveResponseNode(@JsonProperty(value="score") double score, @JsonProperty(value="node") DocumentRetrieveResponseNodeData node) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") ChatCompletionRequestInput input, @JsonProperty(value="parameters") ChatCompletionRequestParameter parameters, @JsonProperty(value="stream") Boolean stream, @JsonIgnore Boolean multiModel) {
        public ChatCompletionRequest(String model, ChatCompletionRequestInput input, Boolean stream) {
            this(model, input, null, stream, false);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") ChatCompletionOutput output, @JsonProperty(value="usage") TokenUsage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequestParameter(@JsonProperty(value="result_format") String resultFormat, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="top_k") Integer topK, @JsonProperty(value="repetition_penalty") Double repetitionPenalty, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="stop") List<Object> stop, @JsonProperty(value="enable_search") Boolean enableSearch, @JsonProperty(value="response_format") DashScopeResponseFormat responseFormat, @JsonProperty(value="incremental_output") Boolean incrementalOutput, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="vl_high_resolution_images") Boolean vlHighResolutionImages) {
        public ChatCompletionRequestParameter() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object function(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankResponse(@JsonProperty(value="output") RerankResponseOutput output, @JsonProperty(value="usage") TokenUsage usage, @JsonProperty(value="request_id") String requestId) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") ChatCompletionOutput output, @JsonProperty(value="usage") TokenUsage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionOutput(@JsonProperty(value="text") String text, @JsonProperty(value="choices") List<Choice> choices) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="message") ChatCompletionMessage message) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TokenUsage(@JsonProperty(value="output_tokens") Integer outputTokens, @JsonProperty(value="input_tokens") Integer inputTokens, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls, @JsonProperty(value="reasoning_content") String reasoningContent) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return "";
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            object = this.rawContent;
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return "";
                }
                Object object2 = list.get(0);
                if (object2 instanceof Map) {
                    Map map = (Map)object2;
                    if (map.isEmpty() || map.get("text") == null) {
                        return "";
                    }
                    return map.get("text").toString();
                }
            }
            throw new IllegalStateException("The content is not valid!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image") String image, @JsonProperty(value="video") List<String> video) {
            public MediaContent(String text) {
                this("text", text, null, null);
            }
        }
    }

    public static enum ChatModel {
        QWEN_PLUS("qwen-plus"),
        QWEN_TURBO("qwen-turbo"),
        QWEN_MAX("qwen-max"),
        QWEN_MAX_LONGCONTEXT("qwen-max-longcontext");

        private final String model;

        private ChatModel(String model) {
            this.model = model;
        }

        public String getModel() {
            return this.model;
        }
    }

    public static enum EmbeddingTextType {
        QUERY("query"),
        DOCUMENT("document");

        public final String value;

        private EmbeddingTextType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public record RerankResponseOutput(@JsonProperty(value="results") List<RerankResponseOutputResult> results) {
    }

    public record RerankResponseOutputResult(@JsonProperty(value="index") Integer index, @JsonProperty(value="relevance_score") Double relevanceScore, @JsonProperty(value="document") Map<String, Object> document) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") RerankRequestInput input, @JsonProperty(value="parameters") RerankRequestParameter parameters) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RerankRequestParameter(@JsonProperty(value="top_n") Integer topN, @JsonProperty(value="return_documents") Boolean returnDocuments) {
    }

    public record RerankRequestInput(@JsonProperty(value="query") String query, @JsonProperty(value="documents") List<String> documents) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LogProbs(@JsonProperty(value="content") List<Content> content) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    public static enum ChatCompletionFinishReason {
        NULL,
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        FUNCTION_CALL,
        TOOL_CALL;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequestInput(@JsonProperty(value="messages") List<ChatCompletionMessage> messages) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FunctionTool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public static enum Type {
            FUNCTION;

        }

        public record Function(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") Map<String, Object> parameters) {
            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DocumentSplitResponse(@JsonProperty(value="chunkService") DocumentSplitResponseData chunkService) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentSplitResponseData(@JsonProperty(value="chunkResult") List<DocumentChunk> chunkResult) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DocumentChunk(@JsonProperty(value="chunk_id") int chunkId, @JsonProperty(value="content") String content, @JsonProperty(value="title") String title, @JsonProperty(value="hier_title") String hierTitle, @JsonProperty(value="nid") String nid, @JsonProperty(value="parent") String parent) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QueryFileResponseData(@JsonProperty(value="category") String category, @JsonProperty(value="file_id") String fileId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="file_type") String fileType, @JsonProperty(value="size_bytes") Long sizeBytes, @JsonProperty(value="status") String status, @JsonProperty(value="upload_time") String uploadtime) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequestInputParameters(@JsonProperty(value="text_type") String textType) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embeddings(@JsonProperty(value="embeddings") List<Embedding> embeddings) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embedding(@JsonProperty(value="text_index") Integer textIndex, @JsonProperty(value="embedding") float[] embedding) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingUsage(@JsonProperty(value="total_tokens") Long totalTokens) implements Usage
    {
        public Integer getPromptTokens() {
            return null;
        }

        public Long getGenerationTokens() {
            return null;
        }

        public Integer getCompletionTokens() {
            return 0;
        }

        public Object getNativeUsage() {
            return null;
        }
    }
}

