/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.image;

import com.alibaba.cloud.ai.dashscope.api.DashScopeImageApi;
import com.alibaba.cloud.ai.dashscope.image.DashScopeImageOptions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DashScopeImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeImageModel.class);
    private static final String DEFAULT_MODEL = "wanx-v1";
    private final DashScopeImageApi dashScopeImageApi;
    private final DashScopeImageOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private static final int MAX_RETRY_COUNT = 10;

    public DashScopeImageModel(DashScopeImageApi dashScopeImageApi) {
        this(dashScopeImageApi, DashScopeImageOptions.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public DashScopeImageModel(DashScopeImageApi dashScopeImageApi, DashScopeImageOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)dashScopeImageApi, (String)"DashScopeImageApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.dashScopeImageApi = dashScopeImageApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public ImageResponse call(ImagePrompt request) {
        Assert.notNull((Object)request, (String)"Prompt must not be null");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)request.getInstructions()) ? 1 : 0) != 0, (String)"Prompt messages must not be empty");
        String taskId = this.submitImageGenTask(request);
        if (taskId == null) {
            return new ImageResponse(List.of());
        }
        for (int retryCount = 0; retryCount < 10; ++retryCount) {
            DashScopeImageApi.DashScopeImageAsyncReponse getResultResponse = this.getImageGenTask(taskId);
            if (getResultResponse != null) {
                String taskStatus;
                DashScopeImageApi.DashScopeImageAsyncReponse.DashScopeImageAsyncReponseOutput output = getResultResponse.output();
                switch (taskStatus = output.taskStatus()) {
                    case "SUCCEEDED": {
                        return this.toImageResponse(output);
                    }
                    case "FAILED": 
                    case "UNKNOWN": {
                        return new ImageResponse(List.of());
                    }
                }
            }
            try {
                Thread.sleep(15000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return new ImageResponse(List.of());
    }

    public String submitImageGenTask(ImagePrompt request) {
        DashScopeImageOptions imageOptions = this.toImageOptions(request.getOptions());
        logger.debug("Image options: {}", (Object)imageOptions);
        DashScopeImageApi.DashScopeImageRequest dashScopeImageRequest = this.constructImageRequest(request, imageOptions);
        ResponseEntity<DashScopeImageApi.DashScopeImageAsyncReponse> submitResponse = this.dashScopeImageApi.submitImageGenTask(dashScopeImageRequest);
        if (submitResponse == null || submitResponse.getBody() == null) {
            logger.warn("Submit imageGen error,request: {}", (Object)request);
            return null;
        }
        return ((DashScopeImageApi.DashScopeImageAsyncReponse)submitResponse.getBody()).output().taskId();
    }

    private DashScopeImageOptions toImageOptions(ImageOptions runtimeOptions) {
        DashScopeImageOptions currentOptions = DashScopeImageOptions.builder().withModel(DEFAULT_MODEL).build();
        if (Objects.nonNull(runtimeOptions)) {
            currentOptions = (DashScopeImageOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, ImageOptions.class, DashScopeImageOptions.class);
        }
        currentOptions = (DashScopeImageOptions)ModelOptionsUtils.merge((Object)currentOptions, (Object)this.defaultOptions, DashScopeImageOptions.class);
        return currentOptions;
    }

    public DashScopeImageApi.DashScopeImageAsyncReponse getImageGenTask(String taskId) {
        ResponseEntity<DashScopeImageApi.DashScopeImageAsyncReponse> getImageGenResponse = this.dashScopeImageApi.getImageGenTaskResult(taskId);
        if (getImageGenResponse == null || getImageGenResponse.getBody() == null) {
            logger.warn("No image response returned for taskId: {}", (Object)taskId);
            return null;
        }
        return (DashScopeImageApi.DashScopeImageAsyncReponse)getImageGenResponse.getBody();
    }

    private ImageResponse toImageResponse(DashScopeImageApi.DashScopeImageAsyncReponse.DashScopeImageAsyncReponseOutput output) {
        List<DashScopeImageApi.DashScopeImageAsyncReponse.DashScopeImageAsyncReponseResult> genImageList = output.results();
        if (genImageList == null || genImageList.isEmpty()) {
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = genImageList.stream().map(entry -> new ImageGeneration(new Image(entry.url(), null))).toList();
        return new ImageResponse(imageGenerationList);
    }

    private DashScopeImageApi.DashScopeImageRequest constructImageRequest(ImagePrompt imagePrompt, DashScopeImageOptions options) {
        return new DashScopeImageApi.DashScopeImageRequest(options.getModel(), new DashScopeImageApi.DashScopeImageRequest.DashScopeImageRequestInput(((ImageMessage)imagePrompt.getInstructions().get(0)).getText(), options.getNegativePrompt(), options.getRefImg()), new DashScopeImageApi.DashScopeImageRequest.DashScopeImageRequestParameter(options.getStyle(), options.getSize(), options.getN(), options.getSeed(), options.getRefStrength(), options.getRefMode()));
    }
}

