/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.image.ImageOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeImageOptions
implements ImageOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="size_width")
    private Integer width;
    @JsonProperty(value="size_height")
    private Integer height;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="style")
    private String style;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="ref_img")
    private String refImg;
    @JsonProperty(value="ref_strength")
    private Float refStrength;
    @JsonProperty(value="ref_mode")
    private String refMode;
    @JsonProperty(value="negative_prompt")
    private String negativePrompt;

    public static Builder builder() {
        return new Builder();
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
        this.size = this.width + "*" + this.height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
        this.size = this.width + "*" + this.height;
    }

    public String getResponseFormat() {
        return null;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        return this.width != null && this.height != null ? this.width + "*" + this.height : null;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public String getRefImg() {
        return this.refImg;
    }

    public void setRefImg(String refImg) {
        this.refImg = refImg;
    }

    public Float getRefStrength() {
        return this.refStrength;
    }

    public void setRefStrength(Float refStrength) {
        this.refStrength = refStrength;
    }

    public String getRefMode() {
        return this.refMode;
    }

    public void setRefMode(String refMode) {
        this.refMode = refMode;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public String toString() {
        return "DashScopeImageOptions{model='" + this.model + "', n=" + this.n + ", width=" + this.width + ", height=" + this.height + ", size='" + this.size + "', style='" + this.style + "', seed=" + this.seed + ", refImg='" + this.refImg + "', refStrength=" + this.refStrength + ", refMode='" + this.refMode + "', negativePrompt='" + this.negativePrompt + "'}";
    }

    public static class Builder {
        private final DashScopeImageOptions options = new DashScopeImageOptions();

        private Builder() {
        }

        public Builder withN(Integer n) {
            this.options.setN(n);
            return this;
        }

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withWidth(Integer width) {
            this.options.setWidth(width);
            return this;
        }

        public Builder withHeight(Integer height) {
            this.options.setHeight(height);
            return this;
        }

        public Builder withStyle(String style) {
            this.options.setStyle(style);
            return this;
        }

        public Builder withSeed(Integer seed) {
            this.options.setSeed(seed);
            return this;
        }

        public Builder withRefImg(String refImg) {
            this.options.setRefImg(refImg);
            return this;
        }

        public Builder withRefStrength(Float refStrength) {
            this.options.setRefStrength(refStrength);
            return this;
        }

        public Builder withRefMode(String refMode) {
            this.options.setRefMode(refMode);
            return this;
        }

        public Builder withNegativePrompt(String negativePrompt) {
            this.options.setNegativePrompt(negativePrompt);
            return this;
        }

        public DashScopeImageOptions build() {
            return this.options;
        }
    }
}

