/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.common.ErrorCodeEnum;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentCloudReaderOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentReader;
import org.springframework.http.ResponseEntity;

public class DashScopeDocumentCloudReader
implements DocumentReader {
    public static final int MAX_TRY_COUNT = 10;
    private static final Logger logger = LoggerFactory.getLogger(DashScopeDocumentCloudReader.class);
    private final DashScopeApi dashScopeApi;
    private DashScopeDocumentCloudReaderOptions readerConfig;
    private File file;

    public DashScopeDocumentCloudReader(String filePath, DashScopeApi dashScopeApi, DashScopeDocumentCloudReaderOptions readerConfig) {
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new RuntimeException(filePath + " Not Exist");
        }
        if (readerConfig == null) {
            readerConfig = new DashScopeDocumentCloudReaderOptions();
        }
        this.readerConfig = readerConfig;
        this.dashScopeApi = dashScopeApi;
    }

    public List<Document> get() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            String fileMD5 = DigestUtils.md5Hex((InputStream)fileInputStream);
            DashScopeApi.UploadRequest uploadRequest = new DashScopeApi.UploadRequest(this.readerConfig.getCategoryId(), this.file.getName(), this.file.length(), fileMD5);
            String fileId = this.dashScopeApi.upload(this.file, uploadRequest);
            for (int tryCount = 0; tryCount < 10; ++tryCount) {
                ResponseEntity<DashScopeApi.CommonResponse<DashScopeApi.QueryFileResponseData>> response = this.dashScopeApi.queryFileInfo(this.readerConfig.getCategoryId(), new DashScopeApi.UploadRequest.QueryFileRequest(fileId));
                if (response != null && response.getBody() != null) {
                    DashScopeApi.QueryFileResponseData queryFileResponseData = (DashScopeApi.QueryFileResponseData)((DashScopeApi.CommonResponse)response.getBody()).data();
                    String fileStatus = queryFileResponseData.status();
                    if ("PARSE_SUCCESS".equals(fileStatus)) {
                        String parseResult = this.dashScopeApi.getFileParseResult(this.readerConfig.getCategoryId(), new DashScopeApi.UploadRequest.QueryFileRequest(fileId));
                        return List.of(this.toDocument(fileId, parseResult));
                    }
                    if ("PARSE_FAILED".equals(fileStatus)) {
                        logger.error("File:{} Read Error\uff0cErrorCode:{},ErrorMessage:{}", new Object[]{this.file.getName(), ((DashScopeApi.CommonResponse)response.getBody()).code(), ((DashScopeApi.CommonResponse)response.getBody()).message()});
                        throw new DashScopeException(ErrorCodeEnum.READER_PARSE_FILE_ERROR);
                    }
                }
                Thread.sleep(30000L);
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("ReadFile Exception", exception);
        }
    }

    private Document toDocument(String fileId, String parseResultText) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("parse_fmt_type", "DASHSCOPE_DOCMIND");
        return new Document(fileId, parseResultText, metaData);
    }
}

