/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.model.MatchMode;

class ConditionItem {
    private String name;
    private MatchMode matchMode;
    private String value;
    private TupleType tupleType;
    private long minimum;
    private long maximum;
    private String[] contain;

    public ConditionItem(String name, String value) {
        this.matchMode = MatchMode.Exact;
        this.name = name;
        this.value = value;
        this.tupleType = TupleType.Two;
    }

    public ConditionItem(String name, long min, long max) {
        this.matchMode = MatchMode.Range;
        this.name = name;
        this.minimum = min;
        this.maximum = max;
        this.tupleType = TupleType.Three;
    }

    public ConditionItem(MatchMode matchMode, String name, String value) {
        this.matchMode = matchMode;
        this.name = name;
        this.value = value;
        this.tupleType = TupleType.Three;
    }

    public ConditionItem(MatchMode matchMode, String name, String[] contain) {
        this.matchMode = matchMode;
        this.name = name;
        this.contain = contain;
        this.tupleType = TupleType.Three;
    }

    public String jsonize() {
        String jsonizedCond = null;
        block0 : switch (this.tupleType) {
            case Two: {
                jsonizedCond = String.format("{\"%s\":\"%s\"},", this.name, this.value);
                break;
            }
            case Three: {
                switch (this.matchMode) {
                    case Exact: {
                        jsonizedCond = String.format("[\"eq\",\"$%s\",\"%s\"],", this.name, this.value);
                        break block0;
                    }
                    case StartWith: {
                        jsonizedCond = String.format("[\"starts-with\",\"$%s\",\"%s\"],", this.name, this.value);
                        break block0;
                    }
                    case Range: {
                        jsonizedCond = String.format("[\"content-length-range\",%d,%d],", this.minimum, this.maximum);
                        break block0;
                    }
                    case In: {
                        jsonizedCond = String.format("[\"in\",\"$%s\",[\"%s\"]],", this.name, StringUtils.join("\",\"", this.contain));
                        break block0;
                    }
                    case NotIn: {
                        jsonizedCond = String.format("[\"not-in\",\"$%s\",[\"%s\"]],", this.name, StringUtils.join("\",\"", this.contain));
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unsupported match mode %s", this.matchMode.toString()));
            }
        }
        return jsonizedCond;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TupleType getTupleType() {
        return this.tupleType;
    }

    public void setTupleType(TupleType tupleType) {
        this.tupleType = tupleType;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    static enum TupleType {
        Two,
        Three;

    }
}

