/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.esg;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.esg.EsgClient;
import com.baidubce.services.esg.EsgClientConfiguration;
import com.baidubce.services.esg.model.EnterpriseSecurityGroupRule;
import com.baidubce.services.esg.model.EsgRuleOperateRequest;
import java.util.Arrays;

public class ExampleAddEsgRule {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "bcc.bj.baidubce.com";
        EsgClientConfiguration config = new EsgClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        EsgClient esgClient = new EsgClient(config);
        EnterpriseSecurityGroupRule enterpriseSecurityGroupRule = new EnterpriseSecurityGroupRule();
        enterpriseSecurityGroupRule.setSourceIp("all");
        enterpriseSecurityGroupRule.setDestIp("all");
        enterpriseSecurityGroupRule.setAction("allow");
        enterpriseSecurityGroupRule.setDirection("ingress");
        enterpriseSecurityGroupRule.setPriority(100);
        enterpriseSecurityGroupRule.setProtocol("tcp");
        enterpriseSecurityGroupRule.setPortRange("2000-3000");
        enterpriseSecurityGroupRule.setEthertype("IPv4");
        EsgRuleOperateRequest esgRuleOperateRequest = new EsgRuleOperateRequest();
        esgRuleOperateRequest.setEnterpriseSecurityGroupId("esg-cza4aa7z2wtd");
        esgRuleOperateRequest.setRules(Arrays.asList(enterpriseSecurityGroupRule));
        try {
            esgClient.authorizeEsgRule(esgRuleOperateRequest);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

