/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.GenericUploadRequest;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PartETag;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CompleteMultipartUploadRequest
extends GenericUploadRequest {
    private ObjectMetadata objectMetadata = new ObjectMetadata();
    private List<PartETag> partETags;
    private boolean xBceCrc32cFlag = false;

    public CompleteMultipartUploadRequest() {
    }

    public CompleteMultipartUploadRequest(String bucketName, String key, String uploadId, List<PartETag> partETags) {
        this(bucketName, key, uploadId, partETags, null);
    }

    public CompleteMultipartUploadRequest(String bucketName, String key, String uploadId, List<PartETag> partETags, ObjectMetadata objectMetadata) {
        super(bucketName, key, uploadId);
        this.partETags = partETags;
        this.objectMetadata = objectMetadata;
    }

    @Override
    public CompleteMultipartUploadRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public CompleteMultipartUploadRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public CompleteMultipartUploadRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    @Override
    public CompleteMultipartUploadRequest withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public CompleteMultipartUploadRequest withObjectMetadata(ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public void setPartETags(List<PartETag> partETags) {
        int partNumber;
        Preconditions.checkNotNull(partETags, (Object)"partETags should not be null.");
        for (int i = 0; i < partETags.size(); ++i) {
            PartETag partETag = partETags.get(i);
            Preconditions.checkNotNull((Object)partETag, (String)"partETags[%s] should not be null.", (Object[])new Object[]{i});
            partNumber = partETag.getPartNumber();
            Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber should be positive. partETags[%s].partNumber:%s", (Object[])new Object[]{i, partNumber});
            Preconditions.checkNotNull((Object)partETag.getETag(), (String)"partETags[%s].eTag should not be null.", (Object[])new Object[]{i});
        }
        Collections.sort(partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag tag1, PartETag tag2) {
                return tag1.getPartNumber() - tag2.getPartNumber();
            }
        });
        int lastPartNumber = 0;
        for (int i = 0; i < partETags.size(); ++i) {
            partNumber = partETags.get(i).getPartNumber();
            Preconditions.checkArgument((partNumber != lastPartNumber ? 1 : 0) != 0, (String)"Duplicated partNumber %s.", (Object[])new Object[]{partNumber});
            lastPartNumber = partNumber;
        }
        this.partETags = partETags;
    }

    public CompleteMultipartUploadRequest withPartETags(List<PartETag> partETags) {
        this.setPartETags(partETags);
        return this;
    }

    public boolean getxBceCrc32cFlag() {
        return this.xBceCrc32cFlag;
    }

    public void setxBceCrc32cFlag(boolean xBceCrc32cFlag) {
        this.xBceCrc32cFlag = xBceCrc32cFlag;
    }
}

