/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.evs;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.evs.EvsClientConfiguration;
import com.baidubce.services.evs.model.BindDeviceRequest;
import com.baidubce.services.evs.model.BindDeviceResponse;
import com.baidubce.services.evs.model.DeviceAiAnalysisListMarkRequest;
import com.baidubce.services.evs.model.DeviceAiAnalysisListMarkResponse;
import com.baidubce.services.evs.model.DeviceChannelGetResponse;
import com.baidubce.services.evs.model.DeviceChannelListResponse;
import com.baidubce.services.evs.model.DeviceChannelSignedUrlResponse;
import com.baidubce.services.evs.model.DeviceCountResponse;
import com.baidubce.services.evs.model.DeviceCreateRequest;
import com.baidubce.services.evs.model.DeviceCreateResponse;
import com.baidubce.services.evs.model.DeviceGetResponse;
import com.baidubce.services.evs.model.DeviceListMarkRequest;
import com.baidubce.services.evs.model.DeviceMarkListResponse;
import com.baidubce.services.evs.model.DeviceSignedUrlResponse;
import com.baidubce.services.evs.model.DeviceStopRequest;
import com.baidubce.services.evs.model.DeviceTsStoreListRequest;
import com.baidubce.services.evs.model.DeviceTsStorePageListResponse;
import com.baidubce.services.evs.model.DeviceUpdateRequest;
import com.baidubce.services.evs.model.DynamicTrafficFrameRequest;
import com.baidubce.services.evs.model.EvsBaseRequest;
import com.baidubce.services.evs.model.EvsBaseResponse;
import com.baidubce.services.evs.model.GBConfigDownloadResponse;
import com.baidubce.services.evs.model.GBDevicePasswordRequest;
import com.baidubce.services.evs.model.GbPresetAddRequest;
import com.baidubce.services.evs.model.GbPresetAddResponse;
import com.baidubce.services.evs.model.GbPresetListResponse;
import com.baidubce.services.evs.model.SpaceCreateRequest;
import com.baidubce.services.evs.model.SpaceCreateResponse;
import com.baidubce.services.evs.model.SpaceGetResponse;
import com.baidubce.services.evs.model.SpaceListMarkRequest;
import com.baidubce.services.evs.model.SpaceMarkListResponse;
import com.baidubce.services.evs.model.SpaceUpdateRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class EvsClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String SDK = "sdk";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String MARKER = "marker";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";
    private static final String STATUS = "status";
    private static final String MAX_SIZE = "maxSize";
    private static final String COUNT = "count";
    private static final String BEGIN = "begin";
    private static final String END = "end";
    private static final String TYPE = "type";
    private static final String RECORDING = "recording";
    private static final String THUMBNAIL = "thumbnail";
    private static final String AI_ANALYSIS = "aiAnalysisByMarker";
    private static final String SIGNED_URL = "signedUrl";
    private static final String PROTOCOL = "protocol";
    private static final String GB_CONFIG_DOWNLOAD = "gbConfigDownload";
    private static final String GB_DEVICE_PASSWORD = "gbDevicePassword";
    private static final String TELE_BOOT = "teleboot";
    private static final String TRAFFIC_FRAME = "trafficFrame";
    private static final String REFRESH = "refresh";
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String PTZ = "ptz";
    private static final String BIND_DEVICE_BY_SN_CODE = "bindDeviceBySnCode";
    public static final String PTZ_COMMAND = "ptzCommand";
    public static final String SPEED = "speed";
    public static final String FI = "fi";
    public static final String FI_COMMAND = "fiCommand";
    public static final String PRESET = "preset";
    public static final String GOTO = "goto";
    private static final String SPACE_URL = "space";
    private static final String SPACE_ID = "spaceId";
    private static final String SPACE_NAME = "spaceName";
    private static final String DEVICE_URL = "device";
    private static final String DEVICE_NAME = "deviceName";
    private static final String DEVICE_ID = "deviceId";
    private static final String CHANNEL_URL = "device/channel";
    private static final String MILLISECONDS_TIMESTAMP = "\\d{13}";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] EVS_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EvsClient() {
        this(new EvsClientConfiguration());
    }

    public EvsClient(BceClientConfiguration clientConfiguration) {
        this(clientConfiguration, EVS_HANDLERS);
    }

    public EvsClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        super(config, responseHandlers);
    }

    public EvsClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers, boolean isHttpAsyncPutEnabled) {
        super(config, responseHandlers, isHttpAsyncPutEnabled);
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    public SpaceCreateResponse createSpace(SpaceCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SPACE_URL);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, SpaceCreateResponse.class);
    }

    public void deleteSpace(long spaceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, SPACE_URL, String.valueOf(spaceId));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void updateSpace(long spaceId, SpaceUpdateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SPACE_URL, String.valueOf(spaceId));
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public SpaceGetResponse getSpace(long spaceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, SPACE_URL, String.valueOf(spaceId));
        return this.invokeHttpClient(internalRequest, SpaceGetResponse.class);
    }

    public SpaceMarkListResponse listSpaceByMarker(SpaceListMarkRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SPACE_URL);
        internalRequest.addParameter(MARKER, null);
        internalRequest.addParameter(MAX_SIZE, String.valueOf(request.getMaxSize()));
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, String.valueOf(request.getMarker()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSpaceName())) {
            internalRequest.addParameter(SPACE_NAME, request.getSpaceName());
        }
        if (request.getStatus() != null) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        if (request.getType() != null) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        return this.invokeHttpClient(internalRequest, SpaceMarkListResponse.class);
    }

    public void disableSpace(long spaceId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SPACE_URL, String.valueOf(spaceId));
        internalRequest.addParameter(DISABLE, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void enableSpace(long spaceId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SPACE_URL, String.valueOf(spaceId));
        internalRequest.addParameter(ENABLE, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceCreateResponse createDevice(DeviceCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE_URL);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeviceCreateResponse.class);
    }

    public void deleteDevice(long deviceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, DEVICE_URL, String.valueOf(deviceId));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void updateDevice(long deviceId, DeviceUpdateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId));
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceGetResponse getDevice(long deviceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId));
        return this.invokeHttpClient(internalRequest, DeviceGetResponse.class);
    }

    public DeviceMarkListResponse listMarkDevice(DeviceListMarkRequest request) {
        Validate.checkNotNull(request.getSpaceId(), "spaceId parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE_URL);
        internalRequest.addParameter(MARKER, null);
        internalRequest.addParameter(MAX_SIZE, String.valueOf(request.getMaxSize()));
        internalRequest.addParameter(SPACE_ID, String.valueOf(request.getSpaceId()));
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, String.valueOf(request.getMarker()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDeviceName())) {
            internalRequest.addParameter(DEVICE_NAME, request.getDeviceName());
        }
        if (request.getStatus() != null) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, DeviceMarkListResponse.class);
    }

    public void disableDevice(long deviceId, DeviceStopRequest request) {
        InternalRequest internalRequest;
        if (request != null) {
            internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId));
            this.fillPayload(internalRequest, request);
        } else {
            EvsBaseRequest evsBaseRequest = new EvsBaseRequest();
            internalRequest = this.createRequest(evsBaseRequest, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId));
            this.fillPayload(internalRequest, evsBaseRequest);
        }
        internalRequest.addParameter(DISABLE, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void enableDevice(long deviceId) {
        EvsBaseRequest evsBaseRequest = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(evsBaseRequest, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId));
        this.fillPayload(internalRequest, evsBaseRequest);
        internalRequest.addParameter(ENABLE, null);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceTsStorePageListResponse listDeviceRecord(long deviceId, DeviceTsStoreListRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(request.getPageNo(), "DeviceTsStoreListRequest.pageNo parameter request should not be null.");
        Validate.checkNotNull(request.getPageSize(), "DeviceTsStoreListRequest.pageSize parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(request.getBegin()));
        internalRequest.addParameter(END, String.valueOf(request.getEnd()));
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        internalRequest.addParameter(TYPE, String.valueOf(request.getType()));
        return this.invokeHttpClient(internalRequest, DeviceTsStorePageListResponse.class);
    }

    public DeviceCountResponse countDeviceRecoding(long deviceId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        internalRequest.addParameter(COUNT, null);
        return this.invokeHttpClient(internalRequest, DeviceCountResponse.class);
    }

    public void removeDeviceRecord(long deviceId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, DEVICE_URL, String.valueOf(deviceId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceTsStorePageListResponse listDeviceThumbnail(long deviceId, DeviceTsStoreListRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(request.getPageNo(), "DeviceTsStoreListRequest.pageNo parameter request should not be null.");
        Validate.checkNotNull(request.getPageSize(), "DeviceTsStoreListRequest.pageSize parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(request.getBegin()));
        internalRequest.addParameter(END, String.valueOf(request.getEnd()));
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, DeviceTsStorePageListResponse.class);
    }

    public DeviceCountResponse countDevicehumbnail(long deviceId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        internalRequest.addParameter(COUNT, null);
        return this.invokeHttpClient(internalRequest, DeviceCountResponse.class);
    }

    public void removeDeviceThumbnail(long deviceId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, DEVICE_URL, String.valueOf(deviceId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceAiAnalysisListMarkResponse listDeviceAiAnalysisResultByMarker(long deviceId, String aiType, DeviceAiAnalysisListMarkRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(aiType, "type parameter request should not be null.");
        Validate.checkPattern(String.valueOf(request.getBegin()), MILLISECONDS_TIMESTAMP, "DeviceTsStoreListRequest.begin parameter request should have a millisecond timestamp.");
        Validate.checkPattern(String.valueOf(request.getEnd()), MILLISECONDS_TIMESTAMP, "DeviceTsStoreListRequest.end parameter request should have a millisecond timestamp.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), AI_ANALYSIS);
        internalRequest.addParameter(TYPE, aiType);
        internalRequest.addParameter(MARKER, null);
        internalRequest.addParameter(MAX_SIZE, String.valueOf(request.getMaxSize()));
        internalRequest.addParameter(BEGIN, String.valueOf(DateUtils.formatIso8601Date(new Date(request.getBegin()))));
        internalRequest.addParameter(END, String.valueOf(DateUtils.formatIso8601Date(new Date(request.getEnd()))));
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, String.valueOf(request.getMarker()));
        }
        return this.invokeHttpClient(internalRequest, DeviceAiAnalysisListMarkResponse.class);
    }

    public DeviceSignedUrlResponse generateDeviceSignedUrl(String domain, String app, String stream, String protocol) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, DEVICE_URL, domain, app, stream, SIGNED_URL);
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            internalRequest.addParameter(PROTOCOL, protocol);
        }
        internalRequest.addParameter(SDK, null);
        return this.invokeHttpClient(internalRequest, DeviceSignedUrlResponse.class);
    }

    public GBConfigDownloadResponse getDeviceGbConfigDownload(long deviceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, DEVICE_URL, String.valueOf(deviceId), GB_CONFIG_DOWNLOAD);
        return this.invokeHttpClient(internalRequest, GBConfigDownloadResponse.class);
    }

    public void teleBootDevice(long deviceId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId));
        internalRequest.addParameter(TELE_BOOT, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceChannelGetResponse trafficFrameDevice(long channelId, DynamicTrafficFrameRequest dynamicTrafficFrame) {
        DynamicTrafficFrameRequest.Configuration configuration = dynamicTrafficFrame.getConfiguration();
        Validate.checkNotNull(configuration, "DynamicTrafficFrameRequest.configuration parameter request should NOT be null.");
        DynamicTrafficFrameRequest.Configuration.FrameLocation frameLocation = configuration.getFrameLocation();
        Validate.checkNotNull(frameLocation, "Configuration.frameLocation parameter request should not be null.");
        Validate.checkNotNull(frameLocation.getHorizontal(), "FrameLocation.horizontal parameter request should not be null.");
        Validate.checkNotNull(frameLocation.getVertical(), "FrameLocation.vertical parameter request should not be null.");
        Validate.checkNotNull(frameLocation.getHeight(), "FrameLocation.height parameter request should not be null.");
        Validate.checkNotNull(frameLocation.getWidth(), "FrameLocation.width parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(dynamicTrafficFrame, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId), TRAFFIC_FRAME);
        this.fillPayload(internalRequest, dynamicTrafficFrame);
        return this.invokeHttpClient(internalRequest, DeviceChannelGetResponse.class);
    }

    public void modifyDeviceGbPassword(long deviceId, GBDevicePasswordRequest request) {
        Validate.checkNotNull(request.getPassword(), "GBDevicePasswordRequest.password parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE_URL, String.valueOf(deviceId), GB_DEVICE_PASSWORD);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceChannelListResponse listChannel(long deviceId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL);
        internalRequest.addParameter(SDK, null);
        internalRequest.addParameter(DEVICE_ID, String.valueOf(deviceId));
        return this.invokeHttpClient(internalRequest, DeviceChannelListResponse.class);
    }

    public void refreshChannels(long deviceId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL);
        internalRequest.addParameter(REFRESH, null);
        internalRequest.addParameter(DEVICE_ID, String.valueOf(deviceId));
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceChannelGetResponse getChannel(long channelId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId));
        internalRequest.addParameter(SDK, null);
        return this.invokeHttpClient(internalRequest, DeviceChannelGetResponse.class);
    }

    public void stopChannel(long channelId, DeviceStopRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId));
        internalRequest.addParameter(STOP, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void startChannel(long channelId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId));
        internalRequest.addParameter(START, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceChannelSignedUrlResponse generateChannelSignedUrl(long channelId, String protocol) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), SIGNED_URL);
        internalRequest.addParameter(SDK, null);
        internalRequest.addParameter(PROTOCOL, protocol);
        return this.invokeHttpClient(internalRequest, DeviceChannelSignedUrlResponse.class);
    }

    public DeviceTsStorePageListResponse listChannelRecord(long channelId, DeviceTsStoreListRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(request.getPageNo(), "DeviceTsStoreListRequest.pageNo parameter request should not be null.");
        Validate.checkNotNull(request.getPageSize(), "DeviceTsStoreListRequest.pageSize parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(request.getBegin()));
        internalRequest.addParameter(END, String.valueOf(request.getEnd()));
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, DeviceTsStorePageListResponse.class);
    }

    public DeviceCountResponse countChannelRecoding(long channelId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        internalRequest.addParameter(COUNT, null);
        return this.invokeHttpClient(internalRequest, DeviceCountResponse.class);
    }

    public void removeChannelRecord(long channelId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, CHANNEL_URL, String.valueOf(channelId), RECORDING);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceTsStorePageListResponse listChannelThumbnail(long channelId, DeviceTsStoreListRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(request.getPageNo(), "DeviceTsStoreListRequest.pageNo parameter request should not be null.");
        Validate.checkNotNull(request.getPageSize(), "DeviceTsStoreListRequest.pageSize parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(request.getBegin()));
        internalRequest.addParameter(END, String.valueOf(request.getEnd()));
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, DeviceTsStorePageListResponse.class);
    }

    public DeviceCountResponse countChannelThumbnail(long channelId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        internalRequest.addParameter(COUNT, null);
        return this.invokeHttpClient(internalRequest, DeviceCountResponse.class);
    }

    public void removeChannelThumbnail(long channelId, long begin, long end) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, CHANNEL_URL, String.valueOf(channelId), THUMBNAIL);
        internalRequest.addParameter(BEGIN, String.valueOf(begin));
        internalRequest.addParameter(END, String.valueOf(end));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public DeviceAiAnalysisListMarkResponse listChannelAiAnalysisResultByMarker(long channelId, String aiType, DeviceAiAnalysisListMarkRequest request) {
        Validate.checkNotNull(request.getBegin(), "DeviceTsStoreListRequest.begin parameter request should not be null.");
        Validate.checkNotNull(request.getEnd(), "DeviceTsStoreListRequest.end parameter request should not be null.");
        Validate.checkNotNull(aiType, "type parameter request should not be null.");
        Validate.checkPattern(String.valueOf(request.getBegin()), MILLISECONDS_TIMESTAMP, "DeviceTsStoreListRequest.begin parameter request should have a millisecond timestamp.");
        Validate.checkPattern(String.valueOf(request.getEnd()), MILLISECONDS_TIMESTAMP, "DeviceTsStoreListRequest.end parameter request should have a millisecond timestamp.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), AI_ANALYSIS);
        internalRequest.addParameter(TYPE, aiType);
        internalRequest.addParameter(MARKER, null);
        internalRequest.addParameter(MAX_SIZE, String.valueOf(request.getMaxSize()));
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, String.valueOf(request.getMarker()));
        }
        internalRequest.addParameter(BEGIN, String.valueOf(DateUtils.formatIso8601Date(new Date(request.getBegin()))));
        internalRequest.addParameter(END, String.valueOf(DateUtils.formatIso8601Date(new Date(request.getEnd()))));
        return this.invokeHttpClient(internalRequest, DeviceAiAnalysisListMarkResponse.class);
    }

    public void modifyChannelPtz(long channelId, String ptzCommand, int speed) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId));
        internalRequest.addParameter(PTZ_COMMAND, ptzCommand.toString());
        internalRequest.addParameter(SPEED, String.valueOf(speed));
        internalRequest.addParameter(PTZ, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public void modifyChannelFi(long channelId, String fiCommand, int speed) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId));
        internalRequest.addParameter(FI_COMMAND, fiCommand.toString());
        internalRequest.addParameter(SPEED, String.valueOf(speed));
        internalRequest.addParameter(FI, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public GbPresetAddResponse addChannelPreset(long channelId, GbPresetAddRequest request) {
        Validate.checkNotNull(request.getName(), "GbPresetAddRequest.name parameter request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CHANNEL_URL, String.valueOf(channelId), PRESET);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GbPresetAddResponse.class);
    }

    public void deleteChannelPreset(long channelId, int presetId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.DELETE, CHANNEL_URL, String.valueOf(channelId), PRESET, String.valueOf(presetId));
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public GbPresetListResponse listChannelPreset(long channelId) {
        InternalRequest internalRequest = this.createRequest(new EvsBaseRequest(), HttpMethodName.GET, CHANNEL_URL, String.valueOf(channelId), PRESET);
        internalRequest.addParameter(SDK, null);
        return this.invokeHttpClient(internalRequest, GbPresetListResponse.class);
    }

    public void gotoChannelPreset(long channelId, int presetId) {
        EvsBaseRequest request = new EvsBaseRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, CHANNEL_URL, String.valueOf(channelId), PRESET, String.valueOf(presetId));
        internalRequest.addParameter(GOTO, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, EvsBaseResponse.class);
    }

    public BindDeviceResponse bindDeviceBySnCode(BindDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE_URL);
        internalRequest.addParameter(BIND_DEVICE_BY_SN_CODE, null);
        Validate.checkNotNull(request.getSnCode(), "BindDeviceRequest.snCode parameter request should not be null.");
        Validate.checkNotNull(request.getDeviceMode(), "BindDeviceRequest.deviceMode parameter request should not be null.");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BindDeviceResponse.class);
    }
}

