/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import org.github.jamm.VM;
import org.github.jamm.utils.MathUtils;

public interface MemoryLayoutSpecification {
    public int getArrayHeaderSize();

    public int getObjectHeaderSize();

    public int getObjectAlignment();

    public int getReferenceSize();

    public int getContendedPaddingWidth();

    public static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        int heapWordSize;
        int referenceSize;
        int objectHeaderSize;
        if (VM.is32Bits()) {
            objectHeaderSize = 8;
            referenceSize = 4;
            heapWordSize = 4;
        } else {
            heapWordSize = 8;
            referenceSize = VM.useCompressedOops() ? 4 : 8;
            objectHeaderSize = VM.useCompressedClassPointers() ? 12 : 16;
        }
        final int objectAlignment = VM.getObjectAlignmentInBytes();
        int arrayLength = 4;
        final int arrayHeaderSize = MathUtils.roundTo(objectHeaderSize + 4, heapWordSize);
        final int contendedPaddingWidth = VM.contendedPaddingWidth();
        return new MemoryLayoutSpecification(){

            @Override
            public int getArrayHeaderSize() {
                return arrayHeaderSize;
            }

            @Override
            public int getObjectHeaderSize() {
                return objectHeaderSize;
            }

            @Override
            public int getObjectAlignment() {
                return objectAlignment;
            }

            @Override
            public int getReferenceSize() {
                return referenceSize;
            }

            @Override
            public int getContendedPaddingWidth() {
                return contendedPaddingWidth;
            }

            public String toString() {
                return "Memory Layout: [objectHeaderSize=" + objectHeaderSize + " , arrayHeaderSize=" + arrayHeaderSize + ", objectAlignment=" + objectAlignment + ", referenceSize=" + referenceSize + ", contendedPaddingWidth=" + contendedPaddingWidth + ']';
            }
        };
    }
}

