/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseRetrofitDegrade;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import com.github.lianjiatech.retrofit.spring.boot.degrade.sentinel.GlobalSentinelDegradeProperty;
import com.github.lianjiatech.retrofit.spring.boot.degrade.sentinel.SentinelDegrade;
import com.github.lianjiatech.retrofit.spring.boot.util.AnnotationExtendUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.RetrofitUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class SentinelRetrofitDegrade
extends BaseRetrofitDegrade {
    protected final GlobalSentinelDegradeProperty globalSentinelDegradeProperty;

    public SentinelRetrofitDegrade(GlobalSentinelDegradeProperty globalSentinelDegradeProperty) {
        this.globalSentinelDegradeProperty = globalSentinelDegradeProperty;
    }

    @Override
    public boolean isEnableDegrade(Class<?> retrofitInterface) {
        if (this.globalSentinelDegradeProperty.isEnable()) {
            SentinelDegrade sentinelDegrade = (SentinelDegrade)AnnotatedElementUtils.findMergedAnnotation(retrofitInterface, SentinelDegrade.class);
            if (sentinelDegrade == null) {
                return true;
            }
            return sentinelDegrade.enable();
        }
        return AnnotationExtendUtils.isAnnotationPresentIncludeMethod(retrofitInterface, SentinelDegrade.class);
    }

    @Override
    public void loadDegradeRules(Class<?> retrofitInterface) {
        Method[] methods;
        for (Method method : methods = retrofitInterface.getMethods()) {
            SentinelDegrade sentinelDegrade;
            if (this.isDefaultOrStatic(method) || !this.needDegrade(sentinelDegrade = AnnotationExtendUtils.findMergedAnnotation(method, method.getDeclaringClass(), SentinelDegrade.class))) continue;
            DegradeRule degradeRule = new DegradeRule().setCount(sentinelDegrade == null ? this.globalSentinelDegradeProperty.getCount() : sentinelDegrade.count()).setTimeWindow(sentinelDegrade == null ? this.globalSentinelDegradeProperty.getTimeWindow() : sentinelDegrade.timeWindow()).setGrade(sentinelDegrade == null ? this.globalSentinelDegradeProperty.getGrade() : sentinelDegrade.grade());
            String resourceName = this.parseResourceName(method);
            degradeRule.setResource(resourceName);
            DegradeRuleManager.setRulesForResource((String)resourceName, Collections.singleton(degradeRule));
        }
    }

    protected boolean needDegrade(SentinelDegrade sentinelDegrade) {
        if (this.globalSentinelDegradeProperty.isEnable()) {
            if (sentinelDegrade == null) {
                return true;
            }
            return sentinelDegrade.enable();
        }
        return sentinelDegrade != null && sentinelDegrade.enable();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Method method = RetrofitUtils.getMethodFormRequest(request);
        if (method == null) {
            return chain.proceed(request);
        }
        SentinelDegrade sentinelDegrade = AnnotationExtendUtils.findMergedAnnotation(method, method.getDeclaringClass(), SentinelDegrade.class);
        if (!this.needDegrade(sentinelDegrade)) {
            return chain.proceed(request);
        }
        String resourceName = this.parseResourceName(method);
        Entry entry = null;
        try {
            entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.OUT);
            Response response = chain.proceed(request);
            return response;
        }
        catch (BlockException e) {
            throw new RetrofitBlockException(e);
        }
        catch (Throwable t) {
            Tracer.trace((Throwable)t);
            throw t;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

