/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.helper;

import com.github.pagehelper.Page;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.util.MetaObjectUtil;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;

public class PostgreSqlDialect
extends AbstractHelperDialect {
    @Override
    public Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, Page page, BoundSql boundSql, CacheKey pageKey) {
        paramMap.put("Second_PageHelper", page.getPageSize());
        paramMap.put("First_PageHelper", page.getStartRow());
        pageKey.update((Object)page.getPageSize());
        pageKey.update((Object)page.getStartRow());
        if (boundSql.getParameterMappings() != null) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
            if (page.getStartRow() == 0L) {
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "Second_PageHelper", Integer.TYPE).build());
            } else {
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "Second_PageHelper", Integer.TYPE).build());
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "First_PageHelper", Long.TYPE).build());
            }
            MetaObject metaObject = MetaObjectUtil.forObject(boundSql);
            metaObject.setValue("parameterMappings", newParameterMappings);
        }
        return paramMap;
    }

    @Override
    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        StringBuilder sqlStr = new StringBuilder(sql.length() + 17);
        sqlStr.append(sql);
        if (page.getStartRow() == 0L) {
            sqlStr.append(" LIMIT ?");
        } else {
            sqlStr.append(" LIMIT ? OFFSET ?");
        }
        return sqlStr.toString();
    }
}

