/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.transport;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey3.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3Client;
import com.netflix.discovery.shared.transport.jersey3.EurekaJersey3ClientImpl;
import com.netflix.discovery.shared.transport.jersey3.Jersey3ApplicationClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.GzipEncodingEnforcingFilter;
import com.netflix.eureka.resources.ServerCodecs;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jersey3RemoteRegionClientFactory
implements TransportClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(Jersey3RemoteRegionClientFactory.class);
    private final EurekaServerConfig serverConfig;
    private final ServerCodecs serverCodecs;
    private final String region;
    private volatile EurekaJersey3Client jerseyClient;
    private final Object lock = new Object();

    @Inject
    public Jersey3RemoteRegionClientFactory(EurekaServerConfig serverConfig, ServerCodecs serverCodecs, String region) {
        this.serverConfig = serverConfig;
        this.serverCodecs = serverCodecs;
        this.region = region;
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new Jersey3ApplicationClient(this.getOrCreateJerseyClient(this.region, endpoint).getClient(), endpoint.getServiceUrl(), (MultivaluedMap)new MultivaluedHashMap());
    }

    public void shutdown() {
        if (this.jerseyClient != null) {
            this.jerseyClient.destroyResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaJersey3Client getOrCreateJerseyClient(String region, EurekaEndpoint endpoint) {
        if (this.jerseyClient != null) {
            return this.jerseyClient;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.jerseyClient == null) {
                EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder clientBuilder = new EurekaJersey3ClientImpl.EurekaJersey3ClientBuilder().withUserAgent("Java-EurekaClient-RemoteRegion").withEncoderWrapper((EncoderWrapper)this.serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)this.serverCodecs.getFullJsonCodec()).withConnectionTimeout(this.serverConfig.getRemoteRegionConnectTimeoutMs()).withReadTimeout(this.serverConfig.getRemoteRegionReadTimeoutMs()).withMaxConnectionsPerHost(this.serverConfig.getRemoteRegionTotalConnectionsPerHost()).withMaxTotalConnections(this.serverConfig.getRemoteRegionTotalConnections()).withConnectionIdleTimeout(this.serverConfig.getRemoteRegionConnectionIdleTimeoutSeconds());
                if (endpoint.isSecure()) {
                    clientBuilder.withClientName("Discovery-RemoteRegionClient-" + region);
                } else if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                    clientBuilder.withClientName("Discovery-RemoteRegionSystemSecureClient-" + region).withSystemSSLConfiguration();
                } else {
                    clientBuilder.withClientName("Discovery-RemoteRegionSecureClient-" + region).withTrustStoreFile(this.serverConfig.getRemoteRegionTrustStore(), this.serverConfig.getRemoteRegionTrustStorePassword());
                }
                this.jerseyClient = clientBuilder.build();
                Client client = this.jerseyClient.getClient();
                boolean enableGZIPContentEncodingFilter = this.serverConfig.shouldGZipContentFromRemoteRegion();
                if (enableGZIPContentEncodingFilter) {
                    client.register(context -> {
                        context.register((Object)new GzipEncodingEnforcingFilter());
                        context.register((Object)new GZipEncoder());
                        return true;
                    });
                }
                String ip = null;
                try {
                    ip = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.warn("Cannot find localhost ip", (Throwable)e);
                }
                EurekaServerIdentity identity = new EurekaServerIdentity(ip);
                client.register(context -> {
                    context.register((Object)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
                    return true;
                });
            }
        }
        return this.jerseyClient;
    }
}

