/*
 * Decompiled with CFR 0.152.
 */
package com.pgvector;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;

public class PGbit
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    private int length;
    private byte[] data;

    public PGbit() {
        this.type = "bit";
    }

    public PGbit(boolean[] v) {
        this();
        this.length = v.length;
        this.data = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.length; ++i) {
            int n = i / 8;
            this.data[n] = (byte)(this.data[n] | (v[i] ? 1 : 0) << 7 - i % 8);
        }
    }

    public PGbit(byte[] v) {
        this();
        this.length = Math.multiplyExact(v.length, 8);
        this.data = v;
    }

    public PGbit(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.data = null;
        } else {
            this.length = s.length();
            this.data = new byte[(this.length + 7) / 8];
            for (int i = 0; i < this.length; ++i) {
                int n = i / 8;
                this.data[n] = (byte)(this.data[n] | (s.charAt(i) != '0' ? 1 : 0) << 7 - i % 8);
            }
        }
    }

    public String getValue() {
        if (this.data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            sb.append((this.data[i / 8] >> 7 - i % 8 & 1) == 1 ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public int lengthInBytes() {
        return this.data == null ? 0 : 4 + this.data.length;
    }

    public void setByteValue(byte[] value, int offset) throws SQLException {
        this.length = ByteConverter.int4((byte[])value, (int)offset);
        this.data = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = value[offset + 4 + i];
        }
    }

    public void toBytes(byte[] bytes, int offset) {
        if (this.data == null) {
            return;
        }
        ByteConverter.int4((byte[])bytes, (int)offset, (int)this.length);
        for (int i = 0; i < this.data.length; ++i) {
            bytes[offset + 4 + i] = this.data[i];
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public boolean[] toArray() {
        boolean[] bits = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            bits[i] = (this.data[i / 8] >> 7 - i % 8 & 1) == 1;
        }
        return bits;
    }

    public static void registerType(Connection conn) throws SQLException {
        conn.unwrap(PGConnection.class).addDataType("bit", PGbit.class);
    }
}

