/*
 * Decompiled with CFR 0.152.
 */
package com.pgvector;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.postgresql.util.PGobject;

public class PGhalfvec
extends PGobject
implements Serializable,
Cloneable {
    private float[] vec;

    public PGhalfvec() {
        this.type = "halfvec";
    }

    public PGhalfvec(float[] v) {
        this();
        this.vec = v;
    }

    public <T extends Number> PGhalfvec(List<T> v) {
        this();
        if (Objects.isNull(v)) {
            this.vec = null;
        } else {
            this.vec = new float[v.size()];
            int i = 0;
            for (Number f : v) {
                this.vec[i++] = f.floatValue();
            }
        }
    }

    public PGhalfvec(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.vec = null;
        } else {
            String[] sp = s.substring(1, s.length() - 1).split(",");
            this.vec = new float[sp.length];
            for (int i = 0; i < sp.length; ++i) {
                this.vec[i] = Float.parseFloat(sp[i]);
            }
        }
    }

    public String getValue() {
        if (this.vec == null) {
            return null;
        }
        return Arrays.toString(this.vec).replace(" ", "");
    }

    public float[] toArray() {
        return this.vec;
    }
}

