/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsRequest;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.SetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryFormat;
import com.qcloud.cos.model.inventory.InventoryFrequency;
import com.qcloud.cos.model.inventory.InventoryIncludedObjectVersions;
import com.qcloud.cos.model.inventory.InventoryOptionalField;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.region.Region;
import java.util.LinkedList;

public class BucketInventoryDemo {
    private static void setGetDeleteBucketInventoryDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-12500000000";
        InventoryConfiguration inventoryConfiguration = new InventoryConfiguration();
        InventoryCosBucketDestination inventoryCosBucketDestination = new InventoryCosBucketDestination();
        inventoryCosBucketDestination.setAccountId("2779643970");
        inventoryCosBucketDestination.setBucketArn("qcs::cos:ap-guangzhou::mybucket-12500000000");
        inventoryCosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
        inventoryCosBucketDestination.setFormat(InventoryFormat.CSV);
        inventoryCosBucketDestination.setPrefix("inventory-output");
        InventoryDestination inventoryDestination = new InventoryDestination();
        inventoryDestination.setCosBucketDestination(inventoryCosBucketDestination);
        inventoryConfiguration.setDestination(inventoryDestination);
        inventoryConfiguration.setEnabled(true);
        inventoryConfiguration.setId("1");
        InventorySchedule inventorySchedule = new InventorySchedule();
        inventorySchedule.setFrequency(InventoryFrequency.Daily);
        inventoryConfiguration.setSchedule(inventorySchedule);
        InventoryPrefixPredicate inventoryFilter = new InventoryPrefixPredicate("test/");
        inventoryConfiguration.setInventoryFilter(new InventoryFilter(inventoryFilter));
        inventoryConfiguration.setIncludedObjectVersions(InventoryIncludedObjectVersions.All);
        LinkedList<String> optionalFields = new LinkedList<String>();
        optionalFields.add(InventoryOptionalField.Size.toString());
        optionalFields.add(InventoryOptionalField.LastModifiedDate.toString());
        inventoryConfiguration.setOptionalFields(optionalFields);
        SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest = new SetBucketInventoryConfigurationRequest();
        setBucketInventoryConfigurationRequest.setBucketName(bucketName);
        setBucketInventoryConfigurationRequest.setInventoryConfiguration(inventoryConfiguration);
        cosclient.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
        inventoryConfiguration.setId("2");
        inventorySchedule.setFrequency(InventoryFrequency.Weekly);
        cosclient.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
        GetBucketInventoryConfigurationResult getBucketInventoryConfigurationResult = cosclient.getBucketInventoryConfiguration(bucketName, "1");
        ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest = new ListBucketInventoryConfigurationsRequest();
        listBucketInventoryConfigurationsRequest.setBucketName(bucketName);
        ListBucketInventoryConfigurationsResult listBucketInventoryConfigurationsResult = cosclient.listBucketInventoryConfigurations(listBucketInventoryConfigurationsRequest);
        DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest = new DeleteBucketInventoryConfigurationRequest();
        deleteBucketInventoryConfigurationRequest.setBucketName(bucketName);
        deleteBucketInventoryConfigurationRequest.setId("1");
        cosclient.deleteBucketInventoryConfiguration(deleteBucketInventoryConfigurationRequest);
    }

    private static void setBucketInventoryDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-12500000000";
        SetBucketInventoryConfigurationRequest request = new SetBucketInventoryConfigurationRequest();
        request.setBucketName(bucketName);
        request.useInventoryText();
        InventoryConfiguration inventoryConfiguration = new InventoryConfiguration();
        inventoryConfiguration.setId("12");
        request.setInventoryConfiguration(inventoryConfiguration);
        String inventoryText = "<InventoryConfiguration>\n<Id>12</Id>\n<IsEnabled>true</IsEnabled>\n<IncludedObjectVersions>All</IncludedObjectVersions>\n<Destination>\n<COSBucketDestination>\n<AccountId>2779643970</AccountId>\n<Bucket>qcs::cos:ap-guangzhou::mybucket-12500000000</Bucket>\n<Prefix>inventory-output</Prefix>\n<Format>CSV</Format>\n<Encryption><SSECOS></SSECOS></Encryption>\n</COSBucketDestination>\n</Destination>\n<Schedule>\n<Frequency>Daily</Frequency>\n</Schedule>\n<Filter>\n<Prefix>test/</Prefix>\n<Period>\n<StartTime>1681661544</StartTime>\n<EndTime>1681733589</EndTime>\n</Period>\n</Filter>\n<OptionalFields>\n<Field>Size</Field>\n<Field>LastModifiedDate</Field>\n</OptionalFields>\n</InventoryConfiguration>\n";
        request.setInventoryText(inventoryText);
        cosclient.setBucketInventoryConfiguration(request);
        cosclient.shutdown();
    }

    public static void main(String[] args) {
        BucketInventoryDemo.setGetDeleteBucketInventoryDemo();
        BucketInventoryDemo.setBucketInventoryDemo();
    }
}

