/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.DecompressionRequest;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.region.Region;

public class DecompressDemo {
    private static final String secretId = "";
    private static final String secretKey = "";
    private static final String bucket = "";
    private static final String region = "";

    public static void main(String[] args) {
        System.out.println(DecompressDemo.postObjectDecompression());
        System.out.println(DecompressDemo.getObjectDecompressionStatus("a.tar.gz"));
        DecompressDemo.listObjectDecompressionJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecompressionResult postObjectDecompression() {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials("", "");
        ClientConfig clientConfig = new ClientConfig(new Region(""));
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            DecompressionRequest decompressionRequest = new DecompressionRequest().setObjectKey("a.tar.gz").setSourceBucketName("").setTargetBucketName("").setPrefixReplaced(true).setResourcesPrefix("").setTargetKeyPrefix("test_out/");
            DecompressionResult decompressionResult = cosClient.postObjectDecompression(decompressionRequest);
            return decompressionResult;
        }
        finally {
            cosClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecompressionResult getObjectDecompressionStatus(String objectKey) {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials("", "");
        ClientConfig clientConfig = new ClientConfig(new Region(""));
        clientConfig.setHttpProtocol(HttpProtocol.http);
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            DecompressionResult decompressionResult = cosClient.getObjectDecompressionStatus("", objectKey, null);
            return decompressionResult;
        }
        finally {
            cosClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listObjectDecompressionJobs() {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials("", "");
        ClientConfig clientConfig = new ClientConfig(new Region(""));
        clientConfig.setHttpProtocol(HttpProtocol.http);
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            ListJobsResult result = cosClient.listObjectDecompressionJobs("", "Success", "asc", "1000", null);
            System.out.println(result);
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static String getPrefix(String objectKey) {
        int index = objectKey.lastIndexOf(47);
        String parent = "";
        if (index != -1) {
            parent = objectKey.substring(0, index + 1);
        }
        return parent;
    }
}

