/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc.service;

import com.google.gson.Gson;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;

public abstract class AbstractService {
    protected Client httpClient;
    protected Auth auth;
    protected final String host = "https://rtc.qiniuapi.com";
    protected Gson gson;
    public static final String JSON_MIME = "application/json";

    public AbstractService(Auth auth) {
        if (null == auth) {
            throw new IllegalArgumentException("auth cannot be null...");
        }
        this.httpClient = new Client();
        this.auth = auth;
        this.gson = new Gson();
    }

    protected Response postCall(Object param, String urlPattern, Object ... pt) throws QiniuException {
        String url = String.format("https://rtc.qiniuapi.com" + urlPattern, pt);
        byte[] body = Json.encode(param).getBytes(Constants.UTF_8);
        StringMap sign = this.auth.authorizationV2(url, "POST", body, JSON_MIME);
        return this.httpClient.post(url, body, sign, JSON_MIME);
    }

    protected Response deleteCall(Object param, String urlPattern, Object ... pt) throws QiniuException {
        String url = String.format("https://rtc.qiniuapi.com" + urlPattern, pt);
        if (null == param) {
            StringMap sign = this.auth.authorizationV2(url, "DELETE", null, null);
            return this.httpClient.delete(url, sign);
        }
        byte[] body = Json.encode(param).getBytes(Constants.UTF_8);
        StringMap sign = this.auth.authorizationV2(url, "DELETE", body, JSON_MIME);
        return this.httpClient.delete(url, body, sign, JSON_MIME);
    }

    protected Response getCall(String urlPattern, Object ... pt) throws QiniuException {
        String url = String.format("https://rtc.qiniuapi.com" + urlPattern, pt);
        StringMap sign = this.auth.authorizationV2(url, "GET", null, null);
        return this.httpClient.get(url, sign);
    }
}

