/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Api;
import com.qiniu.storage.Retry;

final class ApiInterceptorRetrySimple
extends Api.Interceptor {
    private final int retryMax;
    private final Retry.Interval retryInterval;
    private final Retry.RetryCondition retryCondition;

    private ApiInterceptorRetrySimple(int retryMax, Retry.Interval retryInterval, Retry.RetryCondition retryCondition) {
        this.retryMax = retryMax;
        this.retryInterval = retryInterval;
        this.retryCondition = retryCondition;
    }

    @Override
    int priority() {
        return 300;
    }

    @Override
    Api.Response intercept(Api.Request request, Api.Handler handler) throws QiniuException {
        if (request == null || this.retryMax == 0) {
            return handler.handle(request);
        }
        QiniuException exception = null;
        Api.Response response = null;
        int i = 0;
        while (true) {
            exception = null;
            response = null;
            Api.Request cloneRequest = request.clone();
            try {
                response = handler.handle(request);
            }
            catch (QiniuException e) {
                exception = e;
            }
            if (i >= this.retryMax || !this.retryCondition.shouldRetry(request, response, exception) || cloneRequest == null) break;
            request = cloneRequest;
            int interval = this.retryInterval.interval();
            if (interval > 0) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    static final class Builder {
        private int retryMax;
        private Retry.Interval retryInterval;
        private Retry.RetryCondition retryCondition;

        Builder() {
        }

        Builder setRetryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        Builder setRetryInterval(Retry.Interval retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        Builder setRetryCondition(Retry.RetryCondition retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        Api.Interceptor build() {
            if (this.retryMax < 0) {
                this.retryMax = 0;
            }
            if (this.retryInterval == null) {
                this.retryInterval = Retry.defaultInterval();
            }
            if (this.retryCondition == null) {
                this.retryCondition = Retry.defaultCondition();
            }
            return new ApiInterceptorRetrySimple(this.retryMax, this.retryInterval, this.retryCondition);
        }
    }
}

