/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringUtils;
import java.util.List;
import java.util.Map;

public class ApiQueryRegion
extends Api {
    private static final String[] DEFAULT_UC_BACKUP_HOSTS = Configuration.defaultUcHosts;

    public ApiQueryRegion(Client client) {
        this(client, new Api.Config.Builder().setHostRetryMax(DEFAULT_UC_BACKUP_HOSTS.length).setHostProvider(HostProvider.arrayProvider(DEFAULT_UC_BACKUP_HOSTS)).build());
    }

    public ApiQueryRegion(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    static /* synthetic */ String[] access$000() {
        return DEFAULT_UC_BACKUP_HOSTS;
    }

    public static class Response
    extends Api.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getDefaultRegionId() {
            return this.getRegionId(this.getDefaultRegion());
        }

        public String getRegionId(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object regionId = ApiUtils.getValueFromMap(region, "region");
            return regionId.toString();
        }

        public Long getDefaultRegionTTL() {
            return this.getRegionTTL(this.getDefaultRegion());
        }

        public Long getRegionTTL(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object ttl = ApiUtils.getValueFromMap(region, "ttl");
            return ApiUtils.objectToLong(ttl);
        }

        public List<String> getDefaultRegionUpHosts() {
            return this.getRegionUpHosts(this.getDefaultRegion());
        }

        public List<String> getRegionUpHosts(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object domains = ApiUtils.getValueFromMap(region, "up", "domains");
            if (!(domains instanceof List)) {
                return null;
            }
            return (List)domains;
        }

        private Map<String, Object> getDefaultRegion() {
            return this.getRegion(0);
        }

        public Map<String, Object> getRegion(int index) {
            Object value = this.getValueFromDataMap("hosts");
            if (!(value instanceof List) || ((List)value).size() < index) {
                return null;
            }
            Object regionObject = ((List)value).get(index);
            if (!(regionObject instanceof Map)) {
                return null;
            }
            return (Map)regionObject;
        }
    }

    public static class Request
    extends Api.Request {
        private static final String DEFAULT_URL_PREFIX = "https://" + ApiQueryRegion.access$000()[0];
        private String ak;
        private String bucket;

        public Request(String urlPrefix, String token) {
            super(StringUtils.isNullOrEmpty(urlPrefix) ? DEFAULT_URL_PREFIX : urlPrefix);
            this.setMethod(MethodType.GET);
            try {
                UploadToken upToken = new UploadToken(token);
                this.ak = upToken.getAccessKey();
                this.bucket = upToken.getBucket();
            }
            catch (QiniuException e) {
                e.printStackTrace();
            }
        }

        public Request(String urlPrefix, String ak, String bucket) {
            super(StringUtils.isNullOrEmpty(urlPrefix) ? DEFAULT_URL_PREFIX : urlPrefix);
            this.setMethod(MethodType.GET);
            this.ak = ak;
            this.bucket = bucket;
        }

        @Override
        protected void buildQuery() throws QiniuException {
            if (StringUtils.isNullOrEmpty(this.ak) || StringUtils.isNullOrEmpty(this.bucket)) {
                throw QiniuException.unrecoverable("query region error: ak and bucket can't empty");
            }
            this.addQueryPair("ak", this.ak);
            this.addQueryPair("bucket", this.bucket);
            super.buildQuery();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("v4");
            this.addPathSegment("query");
            super.buildPath();
        }
    }
}

