/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.util.BitSet;

public class UrlUtils {
    public static final String ALWAYS_NON_ENCODING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.";
    public static final String PLUS_NON_ENCODING = "~@:$&+,;=/?";
    public static final String PLUS_NON_ENCODING2 = "~@:!$&'()*+,;=/?";
    static final int caseDiff = 32;

    private UrlUtils() {
    }

    public static String composeUrlWithQueries(String url, StringMap queries) {
        StringBuilder queryStr = new StringBuilder();
        if (queries.size() != 0) {
            queryStr.append("?");
            for (String key : queries.keySet()) {
                queryStr.append(key).append("=").append(queries.get(key)).append("&");
            }
            queryStr.deleteCharAt(queryStr.length() - 1);
        }
        return url + queryStr.toString();
    }

    public static String urlEncode(String s) {
        return UrlUtils.urlEncode(s, Charset.forName("UTF-8"));
    }

    public static String urlEncode(String s, String nonEncoding) {
        return UrlUtils.urlEncode(s, Charset.forName("UTF-8"), nonEncoding);
    }

    public static String urlEncode(String s, Charset enc) {
        return UrlUtils.urlEncode(s, enc, PLUS_NON_ENCODING);
    }

    public static String urlEncode(String s, Charset enc, String nonEncoding) {
        BitSet dontNeedEncoding = UrlUtils.buildDontNeedEncoding(nonEncoding);
        return UrlUtils.urlEncode(s, enc, dontNeedEncoding);
    }

    private static BitSet buildDontNeedEncoding(String nonEncoding) {
        BitSet dontNeedEncoding = new BitSet();
        nonEncoding = ALWAYS_NON_ENCODING + nonEncoding;
        for (int i = 0; i < nonEncoding.length(); ++i) {
            char c = nonEncoding.charAt(i);
            dontNeedEncoding.set(c);
        }
        return dontNeedEncoding;
    }

    private static String urlEncode(String s, Charset charset, BitSet dontNeedEncoding) {
        boolean needToChange = false;
        StringBuilder out = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !dontNeedEncoding.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String removeHostScheme(String host) {
        if (host == null || StringUtils.isNullOrEmpty(host)) {
            return null;
        }
        host = host.replace("http://", "");
        host = host.replace("https://", "");
        return host;
    }

    public static String setHostScheme(String host, boolean useHttps) {
        if (host == null || StringUtils.isNullOrEmpty(host)) {
            return null;
        }
        if (host.startsWith("http://") || host.startsWith("https://")) {
            return host;
        }
        return (useHttps ? "https://" : "http://") + host;
    }
}

