/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.SourceLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SourceFolderLibrary
extends SourceLibrary {
    private List<File> sourceFolders = new LinkedList<File>();

    public SourceFolderLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public SourceFolderLibrary(AbstractClassLibrary parent, File sourceFolder) {
        super(parent);
        this.sourceFolders.add(sourceFolder);
    }

    public void addSourceFolder(File sourceFolder) {
        this.sourceFolders.add(sourceFolder);
    }

    protected JavaClass resolveJavaClass(String className) {
        JavaClass result = null;
        for (File sourceFolder : this.sourceFolders) {
            String mainClassName;
            File classFile = new File(sourceFolder, (mainClassName = className.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            if (!classFile.exists() || !classFile.isFile()) continue;
            try {
                JavaSource source = this.parse(new FileReader(classFile), classFile.toURI().toURL());
                result = source.getClassByName(className);
            }
            catch (FileNotFoundException e) {
            }
            catch (MalformedURLException e) {}
        }
        return result;
    }

    protected boolean containsClassReference(String className) {
        boolean result = false;
        Iterator<File> iterator = this.sourceFolders.iterator();
        while (!result && iterator.hasNext()) {
            String mainClassName;
            File sourceFolder = iterator.next();
            File classFile = new File(sourceFolder, (mainClassName = className.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            result = classFile.exists() && classFile.isFile();
        }
        return result;
    }
}

