/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaAnnotation
implements AnnotationValue,
Serializable,
JavaAnnotation {
    private final JavaClass type;
    private final int lineNumber;
    private final Map<String, AnnotationValue> properties = new LinkedHashMap<String, AnnotationValue>();
    private final Map<String, Object> namedParameters = new LinkedHashMap<String, Object>();
    private JavaAnnotatedElement context;

    public DefaultJavaAnnotation(JavaClass type, JavaAnnotatedElement context, Map<String, Object> namedParameters, int lineNumber) {
        this.type = type;
        this.context = context;
        this.lineNumber = lineNumber;
        if (this.properties != null) {
            for (Map.Entry<String, AnnotationValue> entry : this.properties.entrySet()) {
                String name = entry.getKey();
                AnnotationValue value = entry.getValue();
                this.setProperty(name, value);
            }
        }
    }

    public DefaultJavaAnnotation(JavaClass type, int line) {
        this(type, null, null, line);
    }

    public final void setProperty(String name, AnnotationValue value) {
        this.properties.put(name, value);
        this.namedParameters.put(name, value.getParameterValue());
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public Object getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    @Override
    public Map<String, Object> getNamedParameterMap() {
        return this.namedParameters;
    }

    public final JavaAnnotatedElement getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public DefaultJavaAnnotation getParameterValue() {
        return this;
    }

    @Override
    public Map<String, AnnotationValue> getPropertyMap() {
        return this.properties;
    }

    @Override
    public AnnotationValue getProperty(String name) {
        return this.properties.get(name);
    }

    public void setContext(JavaAnnotatedElement context) {
        this.context = context;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(this.type.getFullyQualifiedName());
        result.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator<Map.Entry<String, Object>> i = this.namedParameters.entrySet().iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(',');
            }
        }
        result.append(')');
        return result.toString();
    }
}

