/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModelUtils;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.writer.ModelWriter;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import com.thoughtworks.qdox.writer.impl.DefaultModelWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaSource
implements JavaSource,
Serializable {
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private final ClassLibrary classLibrary;
    private ModelWriterFactory modelWriterFactory;
    private JavaPackage pkg;
    private List<String> imports = new LinkedList<String>();
    private List<JavaClass> classes = new LinkedList<JavaClass>();
    private Map<String, String> resolvedTypeCache = new HashMap<String, String>();
    private URL url;

    public DefaultJavaSource(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public JavaPackage getPackage() {
        return this.pkg;
    }

    public void setPackage(JavaPackage pkg) {
        this.pkg = pkg;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
    }

    @Override
    public List<JavaClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeSource(this).toString();
    }

    public String toString() {
        return this.getCodeBlock();
    }

    @Override
    public String resolveType(String typeName) {
        return this.resolveFullyQualifiedName(typeName);
    }

    @Override
    public String resolveFullyQualifiedName(String name) {
        String result = this.resolvedTypeCache.get(name);
        if (result == null && (result = this.resolveTypeInternal(name)) != null) {
            this.resolvedTypeCache.put(name, result);
        }
        return result;
    }

    @Override
    public String resolveCanonicalName(String name) {
        String className = this.resolveFullyQualifiedName(name);
        String result = null;
        if (className != null) {
            result = className.replace('$', '.');
        }
        return result;
    }

    private String resolveTypeInternal(String typeName) {
        String resolvedName = null;
        if (PRIMITIVE_TYPES.contains(typeName)) {
            resolvedName = typeName;
        } else {
            String outerName = typeName;
            String nestedName = typeName.replace('.', '$');
            int dotpos = typeName.indexOf(46);
            if (dotpos >= 0) {
                outerName = typeName.substring(0, dotpos);
            }
            if ((resolvedName = this.resolveImportedType(typeName, nestedName, true)) != null || (resolvedName = this.resolveImportedType(outerName, nestedName, false)) != null || this.getPackage() != null && (resolvedName = this.resolveFullyQualifiedType(this.getPackageName() + '.' + typeName)) != null || (resolvedName = this.resolveFullyQualifiedType(typeName)) != null || (resolvedName = this.resolveFromLibrary(this.getClassNamePrefix() + nestedName)) != null || (resolvedName = this.resolveFromLibrary("java.lang." + nestedName)) != null || (resolvedName = this.resolveImportedType("*", nestedName, false)) == null) {
                // empty if block
            }
        }
        return resolvedName;
    }

    private String resolveImportedType(String importSpec, String typeName, boolean fullMatch) {
        String resolvedName = null;
        String dotSuffix = "." + importSpec;
        for (String imprt : this.getImports()) {
            if (imprt.startsWith("static ")) {
                imprt = imprt.substring(7);
            }
            if (!imprt.equals(importSpec) && (fullMatch || !imprt.endsWith(dotSuffix))) continue;
            String candidateName = imprt.substring(0, imprt.length() - importSpec.length()) + typeName;
            resolvedName = this.resolveFullyQualifiedType(candidateName);
            if (resolvedName == null && !"*".equals(importSpec)) {
                resolvedName = candidateName;
            }
            if (resolvedName == null) continue;
            break;
        }
        return resolvedName;
    }

    private String resolveFromLibrary(String typeName) {
        return this.classLibrary.hasClassReference(typeName) ? typeName : null;
    }

    private String resolveFullyQualifiedType(String typeName) {
        int indexOfLastDot = typeName.lastIndexOf(46);
        if (indexOfLastDot >= 0) {
            String root = typeName.substring(0, indexOfLastDot);
            String leaf = typeName.substring(indexOfLastDot + 1);
            String resolvedTypeName = this.resolveFullyQualifiedType(root + '$' + leaf);
            if (resolvedTypeName != null) {
                return resolvedTypeName;
            }
        }
        if (this.classLibrary.hasClassReference(typeName)) {
            return typeName;
        }
        return null;
    }

    @Override
    public String getClassNamePrefix() {
        return this.pkg == null ? "" : this.pkg.getName() + '.';
    }

    @Override
    public JavaSource getParentSource() {
        return this;
    }

    @Override
    public JavaClass getNestedClassByName(String name) {
        JavaClass result = null;
        for (JavaClass candidateCls : this.classes) {
            if (!candidateCls.getName().equals(name)) continue;
            result = candidateCls;
            break;
        }
        return result;
    }

    @Override
    public JavaClass getClassByName(String name) {
        JavaClass candidateCls;
        JavaClass result = null;
        Iterator<JavaClass> i$ = this.classes.iterator();
        while (i$.hasNext() && (result = JavaModelUtils.getClassByName(candidateCls = i$.next(), name)) == null) {
        }
        return result;
    }

    @Override
    public ClassLibrary getJavaClassLibrary() {
        return this.classLibrary;
    }

    @Override
    public String getPackageName() {
        return this.pkg == null ? "" : this.pkg.getName();
    }

    public void setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.modelWriterFactory = modelWriterFactory;
    }

    private ModelWriter getModelWriter() {
        ModelWriter result = this.modelWriterFactory != null ? this.modelWriterFactory.newInstance() : new DefaultModelWriter();
        return result;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

