/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractMapper
implements Mapper {
    @Override
    public String select(List<String> columns, List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append(columns.stream().collect(Collectors.joining(",")));
        sql.append(" FROM ");
        sql.append(this.getTableName());
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String insert(List<String> columns) {
        int i;
        StringBuilder sql = new StringBuilder();
        String method = "INSERT INTO ";
        sql.append(method);
        sql.append(this.getTableName());
        int size = columns.size();
        sql.append("(");
        for (i = 0; i < size; ++i) {
            sql.append(columns.get(i).split("@")[0]);
            if (i == columns.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(") ");
        sql.append("VALUES");
        sql.append("(");
        for (i = 0; i < size; ++i) {
            String[] parts = columns.get(i).split("@");
            if (parts.length == 2) {
                sql.append(this.getFunction(parts[1]));
            } else {
                sql.append("?");
            }
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String update(List<String> columns, List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "UPDATE ";
        sql.append(method);
        sql.append(this.getTableName()).append(" ").append("SET ");
        for (int i = 0; i < columns.size(); ++i) {
            String[] parts = columns.get(i).split("@");
            String column = parts[0];
            if (parts.length == 2) {
                sql.append(column).append(" = ").append(this.getFunction(parts[1]));
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String delete(List<String> params) {
        StringBuilder sql = new StringBuilder();
        String method = "DELETE ";
        sql.append(method).append("FROM ").append(this.getTableName());
        this.appendWhereClause(params, sql);
        return sql.toString();
    }

    @Override
    public String count(List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append("COUNT(*) FROM ");
        sql.append(this.getTableName());
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String[] getPrimaryKeyGeneratedKeys() {
        return new String[]{"id"};
    }

    private void appendWhereClause(List<String> where, StringBuilder sql) {
        sql.append(" WHERE ");
        sql.append(where.stream().map(str -> str + " = ?").collect(Collectors.joining(" AND ")));
    }
}

