/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.Collections;
import java.util.List;

public interface HistoryConfigInfoMapper
extends Mapper {
    public MapperResult removeConfigHistory(MapperContext var1);

    default public MapperResult findConfigHistoryCountByTime(MapperContext context) {
        return new MapperResult("SELECT count(*) FROM his_config_info WHERE gmt_modified < ?", Collections.singletonList(context.getWhereParameter("startTime")));
    }

    default public MapperResult findDeletedConfig(MapperContext context) {
        return new MapperResult("SELECT id, nid, data_id, group_id, app_name, content, md5, gmt_create, gmt_modified, src_user, src_ip, op_type, tenant_id, publish_type, gray_name, ext_info, encrypted_data_key FROM his_config_info WHERE op_type = 'D' AND publish_type = ? and gmt_modified >= ? and nid > ? order by nid limit ? ", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("publishType"), context.getWhereParameter("startTime"), context.getWhereParameter("lastMaxId"), context.getWhereParameter("pageSize")}));
    }

    default public MapperResult findConfigHistoryFetchRows(MapperContext context) {
        return new MapperResult("SELECT nid,data_id,group_id,tenant_id,app_name,src_ip,src_user,publish_type,gray_name,op_type,gmt_create,gmt_modified FROM his_config_info WHERE data_id = ? AND group_id = ? AND tenant_id = ? ORDER BY nid DESC", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("dataId"), context.getWhereParameter("groupId"), context.getWhereParameter("tenantId")}));
    }

    public MapperResult pageFindConfigHistoryFetchRows(MapperContext var1);

    default public MapperResult detailPreviousConfigHistory(MapperContext context) {
        return new MapperResult("SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,publish_type,gray_name,ext_info,gmt_create,gmt_modified,encrypted_data_key FROM his_config_info WHERE nid = (SELECT max(nid) FROM his_config_info WHERE id = ?)", Collections.singletonList(context.getWhereParameter("id")));
    }

    @Override
    default public String getTableName() {
        return "his_config_info";
    }

    default public MapperResult getNextHistoryInfo(MapperContext context) {
        String sql = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,publish_type,gray_name,ext_info,gmt_create,gmt_modified,encrypted_data_key FROM his_config_info WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND publish_type = ? " + (StringUtils.isBlank((CharSequence)context.getContextParameter("grayName")) ? "" : "AND gray_name = ? ") + "AND nid > ? ORDER BY nid LIMIT 1";
        List paramList = CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("dataId"), context.getWhereParameter("groupId"), context.getWhereParameter("tenantId"), context.getWhereParameter("publishType"), context.getWhereParameter("nid")});
        if (!StringUtils.isEmpty((String)context.getContextParameter("grayName"))) {
            paramList.add(4, context.getWhereParameter("grayName"));
        }
        return new MapperResult(sql, paramList);
    }
}

