/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2StreamChannel;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpServerMetricsHandler.class);
    boolean channelActivated;
    boolean channelOpened;
    ContextView contextView;
    long dataReceived;
    long dataReceivedTime;
    long dataSent;
    long dataSentTime;
    boolean initialized;
    String method;
    String path;
    SocketAddress remoteSocketAddress;
    String status;
    final Function<String, String> methodTagValue;
    final Function<String, String> uriTagValue;
    static final Set<String> STANDARD_METHODS;
    static final String UNKNOWN_METHOD = "UNKNOWN";
    static final Function<String, String> DEFAULT_METHOD_TAG_VALUE;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        this.methodTagValue = methodTagValue == null ? DEFAULT_METHOD_TAG_VALUE : methodTagValue;
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
        this.channelActivated = copy.channelActivated;
        this.channelOpened = copy.channelOpened;
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.initialized = copy.initialized;
        this.method = copy.method;
        this.path = copy.path;
        this.remoteSocketAddress = copy.remoteSocketAddress;
        this.status = copy.status;
        this.methodTagValue = copy.methodTagValue;
        this.uriTagValue = copy.uriTagValue;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        block3: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    this.channelOpened = true;
                    this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        block4: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    if (this.channelOpened) {
                        this.channelOpened = false;
                        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
        }
        this.recordInactiveConnectionOrStream(ctx.channel());
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof HttpResponse) {
                if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                    ctx.write(msg, promise);
                    return;
                }
                ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    if (!this.initialized) {
                        this.method = this.methodTagValue.apply(ops.method().name());
                        this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                        this.remoteSocketAddress = ops.remoteSocketAddress();
                        this.initialized = true;
                    }
                    if (this.contextView == null) {
                        this.contextView(ops);
                    }
                    this.status = ops.status().codeAsText().toString();
                    this.startWrite(ops);
                }
            }
            this.dataSent += AbstractHttpServerMetricsHandler.extractProcessedDataFromBuffer(msg);
            if (msg instanceof LastHttpContent) {
                promise.addListener(future -> {
                    block2: {
                        try {
                            this.recordWrite(ctx.channel());
                        }
                        catch (RuntimeException e) {
                            if (!log.isWarnEnabled()) break block2;
                            log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                        }
                    }
                    this.recordInactiveConnectionOrStream(ctx.channel());
                });
            }
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        finally {
            ctx.write(msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpServerOperations ops;
        block8: {
            ops = null;
            try {
                if (msg instanceof HttpRequest) {
                    this.reset();
                    ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
                    if (channelOps instanceof HttpServerOperations) {
                        ops = (HttpServerOperations)channelOps;
                        this.method = this.methodTagValue.apply(ops.method().name());
                        this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                        this.remoteSocketAddress = ops.remoteSocketAddress();
                        this.initialized = true;
                        this.startRead(ops);
                    }
                    this.channelActivated = true;
                    if (ctx.channel() instanceof Http2StreamChannel) {
                        this.recordOpenStream(ctx.channel().localAddress());
                    } else {
                        this.recordActiveConnection(ctx.channel().localAddress());
                    }
                }
                this.dataReceived += AbstractHttpServerMetricsHandler.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.recordRead();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireChannelRead(msg);
        if (ops != null) {
            this.contextView(ops);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException();
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private static long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpServerMetricsRecorder recorder();

    protected void contextView(HttpServerOperations ops) {
        this.contextView = Context.empty();
    }

    protected void recordException() {
        this.recorder().incrementErrorsCount(this.remoteSocketAddress, this.path);
    }

    protected void recordRead() {
        this.recorder().recordDataReceivedTime(this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(this.remoteSocketAddress, this.path, this.dataReceived);
    }

    protected void recordWrite(Channel channel) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(this.path, this.method, this.status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(this.path, this.method, this.status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(this.remoteSocketAddress, this.path, this.dataSent);
    }

    protected void recordActiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionActive(localAddress);
    }

    protected void recordInactiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionInactive(localAddress);
    }

    protected void recordOpenStream(SocketAddress localAddress) {
        this.recorder().recordStreamOpened(localAddress);
    }

    protected void recordClosedStream(SocketAddress localAddress) {
        this.recorder().recordStreamClosed(localAddress);
    }

    protected void startRead(HttpServerOperations ops) {
        this.dataReceivedTime = System.nanoTime();
    }

    protected void startWrite(HttpServerOperations ops) {
        this.dataSentTime = System.nanoTime();
    }

    void recordInactiveConnectionOrStream(Channel channel) {
        block5: {
            if (this.channelActivated) {
                this.channelActivated = false;
                try {
                    if (channel instanceof Http2StreamChannel) {
                        this.recordClosedStream(channel.localAddress());
                    } else {
                        this.recordInactiveConnection(channel.localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(ReactorNetty.format((Channel)channel, (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
        }
    }

    void reset() {
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataReceivedTime = 0L;
        this.dataSent = 0L;
        this.dataSentTime = 0L;
        this.initialized = false;
        this.method = null;
        this.path = null;
        this.remoteSocketAddress = null;
        this.status = null;
    }

    static {
        HashSet<String> standardMethods = new HashSet<String>();
        standardMethods.add("GET");
        standardMethods.add("HEAD");
        standardMethods.add("POST");
        standardMethods.add("PUT");
        standardMethods.add("PATCH");
        standardMethods.add("DELETE");
        standardMethods.add("OPTIONS");
        standardMethods.add("TRACE");
        standardMethods.add("CONNECT");
        STANDARD_METHODS = Collections.unmodifiableSet(standardMethods);
        DEFAULT_METHOD_TAG_VALUE = m -> STANDARD_METHODS.contains(m) ? m : UNKNOWN_METHOD;
    }
}

