/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.Iterator;
import java.util.Map;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Buffer;
import zipkin2.internal.JsonEscaper;
import zipkin2.internal.Nullable;

public final class V2SpanWriter
implements Buffer.Writer<Span> {
    @Override
    public int sizeInBytes(Span value) {
        int sizeInBytes = 13;
        sizeInBytes += value.traceId().length();
        if (value.parentId() != null) {
            sizeInBytes += 30;
        }
        sizeInBytes += 24;
        if (value.kind() != null) {
            sizeInBytes += 10;
            sizeInBytes += value.kind().name().length();
        }
        if (value.name() != null) {
            sizeInBytes += 10;
            sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.name());
        }
        if (value.timestampAsLong() != 0L) {
            sizeInBytes += 13;
            sizeInBytes += Buffer.asciiSizeInBytes(value.timestampAsLong());
        }
        if (value.durationAsLong() != 0L) {
            sizeInBytes += 12;
            sizeInBytes += Buffer.asciiSizeInBytes(value.durationAsLong());
        }
        if (value.localEndpoint() != null) {
            sizeInBytes += 17;
            sizeInBytes += V2SpanWriter.endpointSizeInBytes(value.localEndpoint());
        }
        if (value.remoteEndpoint() != null) {
            sizeInBytes += 18;
            sizeInBytes += V2SpanWriter.endpointSizeInBytes(value.remoteEndpoint());
        }
        if (!value.annotations().isEmpty()) {
            sizeInBytes += 17;
            int length = value.annotations().size();
            if (length > 1) {
                sizeInBytes += length - 1;
            }
            for (int i = 0; i < length; ++i) {
                sizeInBytes += V2SpanWriter.annotationSizeInBytes(value.annotations().get(i), null);
            }
        }
        if (!value.tags().isEmpty()) {
            sizeInBytes += 10;
            int tagCount = value.tags().size();
            if (tagCount > 1) {
                sizeInBytes += tagCount - 1;
            }
            for (Map.Entry<String, String> entry : value.tags().entrySet()) {
                sizeInBytes += 5;
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(entry.getKey());
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(entry.getValue());
            }
        }
        if (Boolean.TRUE.equals(value.debug())) {
            sizeInBytes += 13;
        }
        if (Boolean.TRUE.equals(value.shared())) {
            sizeInBytes += 14;
        }
        return ++sizeInBytes;
    }

    @Override
    public void write(Span value, Buffer b) {
        b.writeAscii("{\"traceId\":\"").writeAscii(value.traceId()).writeByte(34);
        if (value.parentId() != null) {
            b.writeAscii(",\"parentId\":\"").writeAscii(value.parentId()).writeByte(34);
        }
        b.writeAscii(",\"id\":\"").writeAscii(value.id()).writeByte(34);
        if (value.kind() != null) {
            b.writeAscii(",\"kind\":\"").writeAscii(value.kind().toString()).writeByte(34);
        }
        if (value.name() != null) {
            b.writeAscii(",\"name\":\"").writeUtf8(JsonEscaper.jsonEscape(value.name())).writeByte(34);
        }
        if (value.timestampAsLong() != 0L) {
            b.writeAscii(",\"timestamp\":").writeAscii(value.timestampAsLong());
        }
        if (value.durationAsLong() != 0L) {
            b.writeAscii(",\"duration\":").writeAscii(value.durationAsLong());
        }
        if (value.localEndpoint() != null) {
            b.writeAscii(",\"localEndpoint\":");
            V2SpanWriter.writeEndpoint(value.localEndpoint(), b);
        }
        if (value.remoteEndpoint() != null) {
            b.writeAscii(",\"remoteEndpoint\":");
            V2SpanWriter.writeEndpoint(value.remoteEndpoint(), b);
        }
        if (!value.annotations().isEmpty()) {
            b.writeAscii(",\"annotations\":");
            b.writeByte(91);
            int i = 0;
            int length = value.annotations().size();
            while (i < length) {
                V2SpanWriter.writeAnnotation(value.annotations().get(i++), null, b);
                if (i >= length) continue;
                b.writeByte(44);
            }
            b.writeByte(93);
        }
        if (!value.tags().isEmpty()) {
            b.writeAscii(",\"tags\":{");
            Iterator<Map.Entry<String, String>> i = value.tags().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> entry = i.next();
                b.writeByte(34).writeUtf8(JsonEscaper.jsonEscape(entry.getKey())).writeAscii("\":\"");
                b.writeUtf8(JsonEscaper.jsonEscape(entry.getValue())).writeByte(34);
                if (!i.hasNext()) continue;
                b.writeByte(44);
            }
            b.writeByte(125);
        }
        if (Boolean.TRUE.equals(value.debug())) {
            b.writeAscii(",\"debug\":true");
        }
        if (Boolean.TRUE.equals(value.shared())) {
            b.writeAscii(",\"shared\":true");
        }
        b.writeByte(125);
    }

    public String toString() {
        return "Span";
    }

    static int endpointSizeInBytes(Endpoint value) {
        int port;
        int sizeInBytes = 1;
        if (value.serviceName() != null) {
            sizeInBytes += 16;
            sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.serviceName());
        }
        if (value.ipv4() != null) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 9;
            sizeInBytes += value.ipv4().length();
        }
        if (value.ipv6() != null) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 9;
            sizeInBytes += value.ipv6().length();
        }
        if ((port = value.portAsInt()) != 0) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 7;
            sizeInBytes += Buffer.asciiSizeInBytes(port);
        }
        return ++sizeInBytes;
    }

    static void writeEndpoint(Endpoint value, Buffer b) {
        int port;
        b.writeByte(123);
        boolean wroteField = false;
        if (value.serviceName() != null) {
            b.writeAscii("\"serviceName\":\"");
            b.writeUtf8(JsonEscaper.jsonEscape(value.serviceName())).writeByte(34);
            wroteField = true;
        }
        if (value.ipv4() != null) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"ipv4\":\"");
            b.writeAscii(value.ipv4()).writeByte(34);
            wroteField = true;
        }
        if (value.ipv6() != null) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"ipv6\":\"");
            b.writeAscii(value.ipv6()).writeByte(34);
            wroteField = true;
        }
        if ((port = value.portAsInt()) != 0) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"port\":").writeAscii(port);
        }
        b.writeByte(125);
    }

    static int annotationSizeInBytes(Annotation value, @Nullable Integer endpointSizeInBytes) {
        int sizeInBytes = 25;
        sizeInBytes += Buffer.asciiSizeInBytes(value.timestamp());
        sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.value());
        if (endpointSizeInBytes != null) {
            sizeInBytes += 12;
            sizeInBytes += endpointSizeInBytes.intValue();
        }
        return sizeInBytes;
    }

    static void writeAnnotation(Annotation value, @Nullable byte[] endpointBytes, Buffer b) {
        b.writeAscii("{\"timestamp\":").writeAscii(value.timestamp());
        b.writeAscii(",\"value\":\"").writeUtf8(JsonEscaper.jsonEscape(value.value())).writeByte(34);
        if (endpointBytes != null) {
            b.writeAscii(",\"endpoint\":").write(endpointBytes);
        }
        b.writeByte(125);
    }
}

